/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.List;

public class IonInputValidator
implements IInputValidator {
    private String[] items;

    public IonInputValidator() {
        this.items = new String[0];
    }

    public IonInputValidator(List list) {
        this.items = list != null ? list.getItems() : new String[0];
    }

    public String isValid(String newText) {
        String item;
        block11: {
            String[] ionList;
            block10: {
                try {
                    ionList = newText.trim().split("-");
                    if (ionList.length != 1) break block10;
                    String ion = String.valueOf(Integer.parseInt(ionList[0].trim()));
                    if (ion.equals("0")) {
                        return "The TIC value (0) must not be added. If the list is empty, 0 is the default.";
                    }
                }
                catch (NumberFormatException e) {
                    return "The input must be an integer value or an integer value range.";
                }
            }
            if (ionList.length == 2) {
                String ion1 = String.valueOf(Integer.parseInt(ionList[0].trim()));
                String ion2 = String.valueOf(Integer.parseInt(ionList[1].trim()));
                if (ion1.equals("0") || ion2.equals("0")) {
                    return "The TIC value (0) must not be added. If the list is empty, 0 is the default.";
                }
                break block11;
            }
            return "The input must be a valid range.";
        }
        String[] stringArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            if (item.equals("0")) {
                return "The TIC value 0 still exists. Remove it before adding ion values.";
            }
            ++n2;
        }
        stringArray = this.items;
        n = this.items.length;
        n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            if (item.equals(newText)) {
                return "The ion value exists already.";
            }
            ++n2;
        }
        return null;
    }
}

