/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.settings;

public class OperatingSystemUtils {
    public static final String TAB = "\t";
    private static final String END_OF_LINE_LINUX = "\n";
    private static final String END_OF_LINE_UNIX = "\n";
    private static final String END_OF_LINE_WINDOWS = "\r\n";
    private static final String END_OF_LINE_MAC = "\r";
    private static final String END_OF_LINE_DEFAULT = "\r\n";

    private OperatingSystemUtils() {
    }

    public static String getLineDelimiter() {
        if (OperatingSystemUtils.isWindows()) {
            return "\r\n";
        }
        if (OperatingSystemUtils.isMac()) {
            return END_OF_LINE_MAC;
        }
        if (OperatingSystemUtils.isLinux()) {
            return "\n";
        }
        if (OperatingSystemUtils.isUnix()) {
            return "\n";
        }
        return "\r\n";
    }

    public static boolean isWindows() {
        return OperatingSystemUtils.getOperatingSystem().indexOf("win") >= 0;
    }

    public static boolean isLinux() {
        return OperatingSystemUtils.getOperatingSystem().indexOf("linux") >= 0;
    }

    public static boolean isMac() {
        return OperatingSystemUtils.getOperatingSystem().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OperatingSystemUtils.getOperatingSystem().indexOf("unix") >= 0;
    }

    private static String getOperatingSystem() {
        return System.getProperty("os.name").toLowerCase();
    }
}

