/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.swt.graphics.Color;

public class UnlimitedColorSchema
implements IColorScheme {
    private static final float brightness = 1.0f;
    private static final float offsetAngle = 0.0f;
    private static final float saturation = 1.0f;
    private static List<Integer> colors;
    private static int INIT_SIZE;
    private int index = 0;

    static {
        INIT_SIZE = 100;
    }

    private List<Integer> getColors(int number) {
        int i = 0;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        float angle = 120.0f;
        float actualAngle = 0.0f;
        float saturOffset = 0.0f;
        float brightOffset = 0.0f;
        int numCycle = 0;
        while (i < number && actualAngle < 360.0f) {
            int c = this.HSBtoRGB(actualAngle / 360.0f, 1.0f, 1.0f);
            colors.add(c);
            actualAngle += angle;
            ++i;
        }
        ++numCycle;
        while (i < number) {
            actualAngle = angle / 2.0f + 0.0f;
            int k = 0;
            while ((float)k < 120.0f / angle && i < number) {
                actualAngle = (float)k * angle + angle / 2.0f + 0.0f;
                int j = 0;
                while (j < 3 && i < number) {
                    if (numCycle == 1) {
                        if (k % 2 == 0) {
                            saturOffset = 0.0f;
                            brightOffset = 0.0f;
                        } else {
                            saturOffset = 0.0f;
                            brightOffset = 0.0f;
                        }
                    } else if (numCycle == 2) {
                        if (k % 2 == 0) {
                            saturOffset = -0.2f;
                            brightOffset = 0.0f;
                        } else {
                            saturOffset = 0.0f;
                            brightOffset = -0.2f;
                        }
                    } else if (numCycle == 3) {
                        if (k % 2 == 0) {
                            saturOffset = -0.4f;
                            brightOffset = -0.1f;
                        } else {
                            saturOffset = -0.1f;
                            brightOffset = -0.4f;
                        }
                    } else if (numCycle > 3) {
                        if (k % 3 == 0) {
                            saturOffset = -0.6f;
                            brightOffset = 0.0f;
                        } else if (k % 3 == 1) {
                            saturOffset = 0.0f;
                            brightOffset = -0.6f;
                        } else if (k % 3 == 2) {
                            saturOffset = -0.4f;
                            brightOffset = -0.4f;
                        }
                    }
                    int c = this.HSBtoRGB(actualAngle / 360.0f, 1.0f + saturOffset, 1.0f + brightOffset);
                    colors.add(c);
                    ++i;
                    actualAngle += 120.0f;
                    ++j;
                }
                ++k;
            }
            angle /= 2.0f;
            ++numCycle;
        }
        return colors;
    }

    private int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public UnlimitedColorSchema() {
        colors = new ArrayList<Integer>();
        colors.addAll(this.getColors(INIT_SIZE));
    }

    @Override
    public int size() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Color getNextColor() {
        this.validatePosition();
        ++this.index;
        return Colors.getColor(colors.get(this.index));
    }

    @Override
    public Color getPreviousColor() {
        this.validatePosition();
        ++this.index;
        return Colors.getColor(colors.get(this.index));
    }

    @Override
    public Color getColor(int i) {
        this.validatePosition();
        return Colors.getColor(colors.get(this.index));
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public Color getColor() {
        return Colors.getColor(colors.get(this.index));
    }

    @Override
    public void incrementColor() {
        ++this.index;
        this.validatePosition();
    }

    private void validatePosition() {
        int size = colors.size();
        if (this.index >= size) {
            List<Integer> extendedColors = this.getColors(size *= 2);
            colors.clear();
            colors.addAll(extendedColors);
        } else if (this.index < 0) {
            this.index = 0;
        }
    }
}

