/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class DatabaseImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(DatabaseImportRunnable.class);
    private File file;
    private IMassSpectra massSpectra;

    public DatabaseImportRunnable(File file) {
        this.file = file;
    }

    public IMassSpectra getMassSpectra() {
        return this.massSpectra;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Database", -1);
                IProcessingInfo processingInfo = DatabaseConverter.convert((File)this.file, (IProgressMonitor)monitor);
                this.massSpectra = (IMassSpectra)processingInfo.getProcessingResult(IMassSpectra.class);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

