/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.ui.parts.EditHistoryPart;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramEditHistory
extends EditHistoryPart {
    private EPartService partService;
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    @Inject
    public ChromatogramEditHistory(Composite parent, EPartService partService, MPart part, IEventBroker eventBroker, EventHandler eventHandler) {
        super(parent, partService, part, eventBroker);
        this.partService = partService;
        this.part = part;
        this.eventBroker = eventBroker;
        this.eventHandler = eventHandler;
        this.subscribe();
    }

    @PreDestroy
    public void preDestroy() {
        this.unsubscribe();
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelection chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    ChromatogramEditHistory.this.doUpdate(chromatogramSelection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandler);
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramselection", this.eventHandler);
            this.eventBroker.subscribe("chromatogram/wsd/update/chromatogramselection", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private void doUpdate(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (this.isPartVisible() && chromatogramSelection != null && chromatogramSelection.getChromatogram() != null) {
            IEditHistory editHistory = chromatogramSelection.getChromatogram().getEditHistory();
            this.setInput(editHistory);
        }
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }
}

