/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReferencedChromatogramDialog
extends TitleAreaDialog {
    private IChromatogram chromatogram;
    private List<Button> checkBoxList;
    private List<IChromatogram> selectedChromatograms;

    public ReferencedChromatogramDialog(Shell parentShell, IChromatogram chromatogram) {
        super(parentShell);
        this.chromatogram = chromatogram;
        this.checkBoxList = new ArrayList<Button>();
        this.selectedChromatograms = new ArrayList<IChromatogram>();
    }

    public List<IChromatogram> getSelectedChromatograms() {
        return this.selectedChromatograms;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Open Referenced Chromatograms");
        this.setMessage("Select additional chromatograms.", 1);
        Composite container = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 512);
        scrolledComposite.setLayout((Layout)new GridLayout(1, true));
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite elementComposite = new Composite((Composite)scrolledComposite, 0);
        elementComposite.setLayout((Layout)new GridLayout(1, true));
        Composite selectDeselectAllComposite = new Composite(elementComposite, 0);
        selectDeselectAllComposite.setLayout((Layout)new GridLayout(2, true));
        Button buttonSelectAll = new Button(selectDeselectAllComposite, 8);
        buttonSelectAll.setText("Select All");
        buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferencedChromatogramDialog.this.setCheckBoxSelection(true);
            }
        });
        Button buttonDeselectAll = new Button(selectDeselectAllComposite, 8);
        buttonDeselectAll.setText("Deselect All");
        buttonDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferencedChromatogramDialog.this.setCheckBoxSelection(false);
            }
        });
        Composite referencedChromatogramsComposite = new Composite(elementComposite, 0);
        referencedChromatogramsComposite.setLayout((Layout)new GridLayout(1, true));
        List references = this.chromatogram.getReferencedChromatograms();
        int counter = 1;
        for (IChromatogram chromatogram : references) {
            Button button = new Button(referencedChromatogramsComposite, 32);
            button.setText("Chromatogram #" + counter++);
            button.setData((Object)chromatogram);
            this.checkBoxList.add(button);
        }
        elementComposite.pack(true);
        scrolledComposite.setMinSize(elementComposite.computeSize(-1, -1));
        scrolledComposite.setContent((Control)elementComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(false);
        scrolledComposite.setAlwaysShowScrollBars(true);
        return container;
    }

    private void setCheckBoxSelection(boolean selected) {
        for (Button button : this.checkBoxList) {
            button.setSelection(selected);
        }
    }

    protected void okPressed() {
        this.saveSelection();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    private void saveSelection() {
        for (Button button : this.checkBoxList) {
            if (button.getSelection()) {
                IChromatogram chromatogram = (IChromatogram)button.getData();
                this.selectedChromatograms.add(chromatogram);
            }
            button.setData(null);
        }
    }
}

