/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.wsd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramImportRunnable.class);
    private File file;
    private ChromatogramSelectionWSD chromatogramSelection;

    public ChromatogramImportRunnable(File file, ChromatogramSelectionWSD chromatogramSelection) {
        this.file = file;
        this.chromatogramSelection = chromatogramSelection;
    }

    public ChromatogramSelectionWSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Chromatogram", -1);
                IProcessingInfo processingInfo = ChromatogramConverterWSD.getInstance().convert(this.file, monitor);
                IChromatogramWSD chromatogram = (IChromatogramWSD)processingInfo.getProcessingResult(IChromatogramWSD.class);
                this.chromatogramSelection = new ChromatogramSelectionWSD(chromatogram);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

