/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import java.util.List;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;

public class ChartSupport {
    private IPreferenceStore preferenceStore;

    public ChartSupport(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public void setAxisSettings(IAxisSettings axisSettings, String positionNode, String pattern, String colorNode, String gridLineStyleNode, String gridColorNode) {
        IAxis.Position position = IAxis.Position.valueOf((String)this.preferenceStore.getString(positionNode));
        Color color = Colors.getColor((String)this.preferenceStore.getString(colorNode));
        LineStyle gridLineStyle = LineStyle.valueOf((String)this.preferenceStore.getString(gridLineStyleNode));
        Color gridColor = Colors.getColor((String)this.preferenceStore.getString(gridColorNode));
        this.setAxisSettings(axisSettings, position, pattern, color, gridLineStyle, gridColor);
    }

    public ISecondaryAxisSettings getSecondaryAxisSettingsX(String title, IChartSettings chartSettings) {
        return this.getSecondaryAxisSettings(chartSettings.getSecondaryAxisSettingsListX(), title);
    }

    public ISecondaryAxisSettings getSecondaryAxisSettingsY(String title, IChartSettings chartSettings) {
        return this.getSecondaryAxisSettings(chartSettings.getSecondaryAxisSettingsListY(), title);
    }

    public ISecondaryAxisSettings getSecondaryAxisSettings(List<ISecondaryAxisSettings> secondaryAxisSettingsList, String title) {
        ISecondaryAxisSettings secondaryAxisSettings = null;
        for (ISecondaryAxisSettings secondaryAxisSetting : secondaryAxisSettingsList) {
            if (!title.equals(secondaryAxisSetting.getTitle())) continue;
            secondaryAxisSettings = secondaryAxisSetting;
        }
        return secondaryAxisSettings;
    }

    public boolean getBoolean(String preferenceName) {
        return this.preferenceStore.getBoolean(preferenceName);
    }

    public void setAxisSettings(IAxisSettings axisSettings, IAxis.Position position, String decimalPattern, Color color, LineStyle gridLineStyle, Color gridColor) {
        if (axisSettings != null) {
            axisSettings.setPosition(position);
            axisSettings.setDecimalFormat(ValueFormat.getDecimalFormatEnglish((String)decimalPattern));
            axisSettings.setColor(color);
            axisSettings.setGridColor(gridColor);
            axisSettings.setGridLineStyle(gridLineStyle);
        }
    }
}

