/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.PostConstruct;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakScanListUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PeakListEditor {
    @PostConstruct
    public void construct(Composite parent, final ISupplier supplier, final File file) {
        final PeakScanListUI scanListUI = new PeakScanListUI(parent, 0);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final IProcessingInfo convert = PeakConverterMSD.convert((File)file, (String)supplier.getId(), (IProgressMonitor)monitor);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IPeaks result = (IPeaks)convert.getProcessingResult();
                            if (convert.hasErrorMessages() || result == null) {
                                ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)convert);
                            } else {
                                scanListUI.setInput(result);
                            }
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            ProcessingInfoViewSupport.updateProcessingInfoError((String)"PeakListEditor", (String)("Open file " + file.getAbsolutePath() + " failed"), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

