/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ScanLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanTableUI;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class ScanSignalEditingSupport
extends EditingSupport {
    private static final Logger logger = Logger.getLogger(ScanSignalEditingSupport.class);
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public ScanSignalEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        if (this.column.equals(ScanLabelProvider.INTENSITY)) {
            return this.tableViewer.isEditEnabled();
        }
        return false;
    }

    protected Object getValue(Object element) {
        boolean editIsEnabled = this.tableViewer.isEditEnabled();
        if (editIsEnabled && this.column.equals(ScanLabelProvider.INTENSITY)) {
            if (element instanceof IIon) {
                IIon ion = (IIon)element;
                return Float.toString(ion.getAbundance());
            }
            if (element instanceof IScanSignalWSD) {
                IScanSignalWSD scanSignalWSD = (IScanSignalWSD)element;
                return Float.toString(scanSignalWSD.getAbundance());
            }
            if (element instanceof IScanCSD) {
                IScanCSD scanCSD = (IScanCSD)element;
                return Float.toString(scanCSD.getTotalSignal());
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        float abundance;
        if (this.column.equals(ScanLabelProvider.INTENSITY) && (abundance = this.parseValue(value)) > 0.0f) {
            if (element instanceof IIon) {
                IIon ion = (IIon)element;
                try {
                    ion.setAbundance(abundance);
                    this.updateTable();
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
            } else if (element instanceof IScanSignalWSD) {
                IScanSignalWSD scanSignalWSD = (IScanSignalWSD)element;
                scanSignalWSD.setAbundance(abundance);
                this.updateTable();
            } else if (element instanceof IScanCSD) {
                logger.info((Object)"It's not possible to edit the CSD scan total signal at the moment.");
            }
        }
    }

    private void updateTable() {
        if (this.tableViewer instanceof ScanTableUI) {
            ScanTableUI scanTableUI = (ScanTableUI)this.tableViewer;
            scanTableUI.updateScan();
        }
    }

    private float parseValue(Object value) {
        float result = 0.0f;
        try {
            result = Float.parseFloat(value.toString().trim());
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return result;
    }
}

