/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.converter.model.reports.ISequenceRecord;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class SequenceListLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String SAMPLE_NAME = "Sample Name";
    public static final String DATA_PATH = "Data Path";
    public static final String DATA_FILE = "Data File";
    public static final String ADVICE = "Advice";
    public static final String VIAL = "Vial";
    public static final String SUBSTANCE = "Substance";
    public static final String DESCRIPTION = "Description";
    public static final String PROCESS_METHOD = "Process Method";
    public static final String MULTIPLIER = "Multiplier";
    public static final String INJECTION_VOLUME = "Injection Volume";
    public static final String REPORT_METHOD = "Report Method";
    public static String[] TITLES = new String[]{"Sample Name", "Data Path", "Data File", "Advice", "Vial", "Substance", "Description", "Process Method", "Report Method", "Multiplier", "Injection Volume"};
    public static int[] BOUNDS = new int[]{200, 150, 150, 200, 60, 150, 150, 150, 150, 60, 60};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 3 && element instanceof ISequenceRecord) {
            ISequenceRecord sequenceRecord = (ISequenceRecord)element;
            switch (sequenceRecord.getAdvice()) {
                case NONE: {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-empty.gif", "16x16");
                }
                case DATA_IS_VALID: {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-ok.gif", "16x16");
                }
                case FILE_NOT_AVAILABLE: {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-error.gif", "16x16");
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof ISequenceRecord) {
            ISequenceRecord sequenceRecord = (ISequenceRecord)element;
            switch (columnIndex) {
                case 0: {
                    text = sequenceRecord.getSampleName();
                    break;
                }
                case 1: {
                    text = sequenceRecord.getDataPath();
                    break;
                }
                case 2: {
                    text = sequenceRecord.getDataFile();
                    break;
                }
                case 3: {
                    text = sequenceRecord.getAdvice().getDecsription();
                    break;
                }
                case 4: {
                    text = Integer.toString(sequenceRecord.getVial());
                    break;
                }
                case 5: {
                    text = sequenceRecord.getSubstance();
                    break;
                }
                case 6: {
                    text = sequenceRecord.getDescription();
                    break;
                }
                case 7: {
                    text = sequenceRecord.getProcessMethod();
                    break;
                }
                case 8: {
                    text = sequenceRecord.getReportMethod();
                    break;
                }
                case 9: {
                    text = decimalFormat.format(sequenceRecord.getMultiplier());
                    break;
                }
                case 10: {
                    text = decimalFormat.format(sequenceRecord.getInjectionVolume());
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/peak.gif", "16x16");
    }
}

