/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.lang.ref.SoftReference;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.ObjectChangedListener;

public abstract class AbstractNotifications<T> {
    private Set<ObjectChangedListener<? super T>> listeners = new CopyOnWriteArraySet<ObjectChangedListener<? super T>>();
    private SoftReference<T> selectedObject;

    public void addObjectChangedListener(ObjectChangedListener<? super T> listener) {
        this.listeners.add(listener);
        T object = this.getSelection();
        if (object != null) {
            listener.objectChanged(ObjectChangedListener.ChangeType.SELECTED, object, null);
        }
    }

    public void removeObjectChangedListener(ObjectChangedListener<? super T> listener) {
        this.listeners.remove(listener);
        T object = this.getSelection();
        if (object != null) {
            listener.objectChanged(ObjectChangedListener.ChangeType.SELECTED, null, object);
        }
    }

    public void created(T object) {
        for (ObjectChangedListener<Object> objectChangedListener : this.listeners) {
            objectChangedListener.objectChanged(ObjectChangedListener.ChangeType.CREATED, object, null);
        }
    }

    public void updated(T newObject, T oldObject) {
        for (ObjectChangedListener<T> listener : this.listeners) {
            listener.objectChanged(ObjectChangedListener.ChangeType.CHANGED, newObject, oldObject);
        }
    }

    public void select(T selection) {
        T object = this.getSelection();
        this.selectedObject = selection == null ? null : new SoftReference<T>(selection);
        for (ObjectChangedListener<T> listener : this.listeners) {
            listener.objectChanged(ObjectChangedListener.ChangeType.SELECTED, selection, object);
        }
    }

    public T getSelection() {
        if (this.selectedObject == null) {
            return null;
        }
        return this.selectedObject.get();
    }
}

