/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.SelectableTargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.VisibilityTargetDisplaySettings;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class WorkspaceTargetDisplaySettings
implements TargetDisplaySettings,
SelectableTargetDisplaySettings,
VisibilityTargetDisplaySettings {
    private static final String KEY_SYSTEM_SETTINGS = "useSystemSettings";
    private static IEclipsePreferences preferences;
    private final Preferences node;
    private final TargetDisplaySettings systemSettings;
    private TargetDisplaySettings userSettings;

    private WorkspaceTargetDisplaySettings(Preferences node, TargetDisplaySettings systemSettings) {
        this.node = node;
        this.systemSettings = systemSettings;
    }

    private boolean isUseSystemSettings() {
        return this.systemSettings != null && this.node.getBoolean(KEY_SYSTEM_SETTINGS, true);
    }

    @Override
    public boolean isShowPeakLabels() {
        if (this.isUseSystemSettings()) {
            return this.systemSettings.isShowPeakLabels();
        }
        return this.node.getBoolean("showChromatogramPeakLabels", true);
    }

    @Override
    public boolean isShowScanLables() {
        if (this.isUseSystemSettings()) {
            return this.systemSettings.isShowScanLables();
        }
        return this.node.getBoolean("showChromatogramScanLabels", true);
    }

    @Override
    public TargetDisplaySettings.LibraryField getField() {
        if (this.isUseSystemSettings()) {
            return this.systemSettings.getField();
        }
        String string = this.node.get("targetLabelField", null);
        if (string != null) {
            return TargetDisplaySettings.LibraryField.valueOf(string);
        }
        return TargetDisplaySettings.LibraryField.NAME;
    }

    private TargetDisplaySettings getSystemSettings() {
        return this.systemSettings;
    }

    private TargetDisplaySettings getUserSettings() {
        if (this.systemSettings == null) {
            return this;
        }
        if (this.userSettings == null) {
            this.userSettings = new WorkspaceTargetDisplaySettings(this.node, null);
        }
        return this.userSettings;
    }

    @Override
    public boolean isVisible(TargetReference reference) {
        if (this.isUseSystemSettings()) {
            if (this.systemSettings instanceof VisibilityTargetDisplaySettings) {
                return ((VisibilityTargetDisplaySettings)this.systemSettings).isVisible(reference);
            }
            return true;
        }
        if (reference == null) {
            return false;
        }
        return this.node.getBoolean(reference.getID(), true);
    }

    @Override
    public int getRotation() {
        if (this.isUseSystemSettings()) {
            return this.systemSettings.getRotation();
        }
        return this.node.getInt("chromatogramPeakLabelsRotation", 90);
    }

    @Override
    public int getCollisionDetectionDepth() {
        if (this.isUseSystemSettings()) {
            return this.systemSettings.getCollisionDetectionDepth();
        }
        return this.node.getInt("chromatogramPeakLabelsCollisionDetectionDepth", 0);
    }

    @Override
    public void setCollisionDetectionDepth(int depth) {
        this.node.putInt("chromatogramPeakLabelsCollisionDetectionDepth", depth);
    }

    @Override
    public void setShowPeakLabels(boolean showPeakLabels) {
        this.node.putBoolean("showChromatogramPeakLabels", showPeakLabels);
    }

    @Override
    public void setRotation(int degree) {
        this.node.putInt("chromatogramPeakLabelsRotation", degree);
    }

    @Override
    public void setShowScanLables(boolean showScanLables) {
        this.node.putBoolean("showChromatogramScanLabels", showScanLables);
    }

    @Override
    public void setField(TargetDisplaySettings.LibraryField libraryField) {
        this.node.put("targetLabelField", libraryField.name());
    }

    private void setUseSystemSettings(boolean useSystemSettings) {
        this.node.putBoolean(KEY_SYSTEM_SETTINGS, useSystemSettings);
    }

    @Override
    public void setVisible(TargetReference reference, boolean visible) {
        if (visible) {
            this.node.remove(reference.getID());
        } else {
            this.node.putBoolean(reference.getID(), false);
        }
    }

    public void flush() {
        try {
            this.node.flush();
        }
        catch (BackingStoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, WorkspaceTargetDisplaySettings.class.getName(), "Flush WorkspaceTargetDisplaySettings failed!", (Throwable)e));
        }
    }

    public static WorkspaceTargetDisplaySettings getWorkspaceSettings(File file, TargetDisplaySettings systemSettings) {
        Preferences node;
        if (file == null) {
            node = WorkspaceTargetDisplaySettings.getStorage().node("TargetDisplaySettingsWizard");
        } else {
            String path;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                path = file.getAbsolutePath();
            }
            node = WorkspaceTargetDisplaySettings.getStorage().node(path.replace('/', '_').replace('.', '_'));
            node.put("FilePath", path);
        }
        try {
            node.sync();
        }
        catch (BackingStoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, WorkspaceTargetDisplaySettings.class.getName(), "Sync WorkspaceTargetDisplaySettings failed!", (Throwable)e));
        }
        return new WorkspaceTargetDisplaySettings(node, systemSettings);
    }

    private static IEclipsePreferences getStorage() {
        if (preferences == null) {
            preferences = InstanceScope.INSTANCE.getNode(TargetDisplaySettings.class.getName());
        }
        return preferences;
    }

    @Override
    public Map<String, TargetDisplaySettings> getSettings() {
        LinkedHashMap<String, TargetDisplaySettings> map = new LinkedHashMap<String, TargetDisplaySettings>(2);
        map.put("System Defaults", this.getSystemSettings());
        map.put("Individual Settings", this.getUserSettings());
        return map;
    }

    @Override
    public boolean isSelectedSettings(TargetDisplaySettings settings) {
        if (this.isUseSystemSettings()) {
            return settings == this.getSystemSettings();
        }
        return settings == this.getUserSettings();
    }

    @Override
    public void setSelectedSettings(TargetDisplaySettings settings) {
        this.setUseSystemSettings(settings == this.getSystemSettings());
    }
}

