/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.chemclipse.model.handler.IModificationHandler;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.DataListUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.DataListUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.MethodUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedMethodUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BatchJobUI {
    private IModificationHandler modificationHandler;
    private final DataListUI listUI;
    private final ExtendedMethodUI extendedMethodUI;
    private final Composite composite;

    @Deprecated
    public BatchJobUI(Composite parent, ProcessSupplierContext processingSupport, IPreferenceStore preferenceStore, String userlocationPrefrenceKey, DataType[] dataTypes, IRunnableWithProgress executionRunnable) {
        this(parent, processingSupport, preferenceStore, userlocationPrefrenceKey, DataType.convert((DataType[])dataTypes), executionRunnable);
    }

    public BatchJobUI(Composite parent, ProcessSupplierContext processingSupport, IPreferenceStore preferenceStore, String userlocationPrefrenceKey, DataCategory[] dataCategories, IRunnableWithProgress executionRunnable) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, true));
        ToolBar toolBar = new ToolBar(this.composite, 0x800000);
        this.initToolbar(toolBar, executionRunnable);
        this.listUI = this.createDataList(this.composite, preferenceStore, userlocationPrefrenceKey, dataCategories);
        this.listUI.getControl().setLayoutData((Object)new GridData(1808));
        this.listUI.getConfig().setToolbarVisible(false);
        this.extendedMethodUI = new ExtendedMethodUI(this.composite, 0, processingSupport, dataCategories);
        this.extendedMethodUI.setLayoutData(new GridData(1808));
        this.extendedMethodUI.setModificationHandler(this::setEditorDirty);
        this.extendedMethodUI.getConfig().setToolbarVisible(false);
    }

    protected DataListUI createDataList(Composite parent, IPreferenceStore preferenceStore, String userlocationPrefrenceKey, DataCategory[] dataCategories) {
        return new DataListUI(parent, this::setEditorDirty, preferenceStore, userlocationPrefrenceKey, DataType.convert((DataCategory[])dataCategories));
    }

    private void initToolbar(ToolBar toolBar, IRunnableWithProgress executionRunnable) {
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        gridData.horizontalSpan = 2;
        toolBar.setLayoutData((Object)gridData);
        this.createExecuteButton(toolBar, executionRunnable);
        this.createSettingsButton(toolBar);
    }

    private ToolItem createSettingsButton(final ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setText("Settings");
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        item.setToolTipText("Modify the settings.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                DataListUIConfig configListUI = BatchJobUI.this.listUI.getConfig();
                this.addPages("listUI", configListUI.getPreferencePages(), preferenceManager);
                MethodUIConfig methodUIConfig = BatchJobUI.this.extendedMethodUI.getConfig();
                this.addPages("extendedMethodUI", methodUIConfig.getPreferencePages(), preferenceManager);
                PreferenceDialog preferenceDialog = new PreferenceDialog(toolBar.getShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    configListUI.applySettings();
                    methodUIConfig.applySettings();
                }
            }

            private void addPages(String prefix, IPreferencePage[] preferencePages, PreferenceManager preferenceManager) {
                int i = 0;
                while (i < preferencePages.length) {
                    preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(String.valueOf(prefix) + "." + (i + 1), preferencePages[i]));
                    ++i;
                }
            }
        });
        return item;
    }

    private ToolItem createExecuteButton(final ToolBar toolBar, final IRunnableWithProgress executionRunnable) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setText("Execute Job");
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        item.setToolTipText("Execute the batch job.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressMonitorDialog monitor = new ProgressMonitorDialog(toolBar.getShell());
                try {
                    monitor.run(true, true, executionRunnable);
                }
                catch (InvocationTargetException e) {
                    ProcessingInfoViewSupport.updateProcessingInfoError((String)"BatchJob", (String)"Execution of the job failed", (Throwable)e.getCause());
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        return item;
    }

    public void doLoad(List<File> files, IProcessMethod processMethod) {
        this.listUI.setFiles(files);
        this.extendedMethodUI.setProcessMethod(processMethod);
        if (this.modificationHandler != null) {
            this.modificationHandler.setDirty(false);
        }
    }

    public DataListUI getDataList() {
        return this.listUI;
    }

    public ExtendedMethodUI getMethod() {
        return this.extendedMethodUI;
    }

    public void setModificationHandler(IModificationHandler modificationHandler) {
        this.modificationHandler = modificationHandler;
    }

    protected void setEditorDirty(boolean dirty) {
        if (this.modificationHandler != null) {
            this.modificationHandler.setDirty(dirty);
        }
    }

    public void setFocus() {
        this.composite.setFocus();
    }
}

