/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.listener.SplitSelectionPaintListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ManualPeakDetector;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePeaks;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakChartUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class ExtendedPeakChartUI {
    private static final Logger logger = Logger.getLogger(ExtendedPeakChartUI.class);
    private static final String DETECTION_TYPE_TANGENT = "DETECTION_TYPE_TANGENT";
    private static final String DETECTION_TYPE_PERPENDICULAR = "DETECTION_TYPE_TYPE_PERPENDICULAR";
    private static final String DETECTION_TYPE_NONE = "";
    private Map<String, String> detectionTypeDescriptions;
    private static final char KEY_TANGENT = 't';
    private static final char KEY_PERPENDICULAR = 'p';
    private Composite toolbarInfo;
    private Label labelPeak;
    private Label labelDetectionType;
    private Button buttonDetectionTypeTangent;
    private Button buttonDetectionTypePerpendicular;
    private Button buttonAddPeak;
    private PeakChartUI peakChart;
    private IPeak peak = null;
    private IPeak peakSplitted1 = null;
    private IPeak peakSplitted2 = null;
    private SplitSelectionPaintListener splitSelectionPaintListener;
    private int xStart;
    private int xStop;
    private String detectionType = "";
    private PeakDataSupport peakDataSupport = new PeakDataSupport();

    @Inject
    public ExtendedPeakChartUI(Composite parent) {
        this.detectionTypeDescriptions = new HashMap<String, String>();
        this.detectionTypeDescriptions.put(DETECTION_TYPE_TANGENT, "Modus (Tangent) [Key:t]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_PERPENDICULAR, "Modus (Perpendicular) [Key:p]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_NONE, DETECTION_TYPE_NONE);
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updatePeaks();
    }

    public void update(IPeak peak) {
        this.peak = peak;
        this.resetSplittedPeaks();
        this.labelPeak.setText(this.peakDataSupport.getPeakLabel(peak));
        if (peak instanceof IChromatogramPeakCSD || peak instanceof IChromatogramPeakMSD) {
            this.buttonDetectionTypeTangent.setEnabled(true);
            this.buttonDetectionTypePerpendicular.setEnabled(true);
        } else {
            this.buttonDetectionTypeTangent.setEnabled(false);
            this.buttonDetectionTypePerpendicular.setEnabled(false);
        }
        this.updatePeaks();
    }

    private void updatePeaks() {
        if (this.peakSplitted1 == null && this.peakSplitted2 == null) {
            this.peakChart.setInput(this.peak);
        } else {
            this.peakChart.setInput(this.peakSplitted1, this.peakSplitted2);
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createPeakChart(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(9, false));
        this.labelDetectionType = this.createDetectionTypeLabel(composite);
        this.createButtonToggleToolbarInfo(composite);
        this.buttonDetectionTypeTangent = this.createDetectionTypeTangentButton(composite);
        this.buttonDetectionTypePerpendicular = this.createDetectionTypePerpendicularButton(composite);
        this.buttonAddPeak = this.createAddPeakButton(composite);
        this.createToggleChartSeriesLegendButton(composite);
        this.createToggleLegendMarkerButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Label createDetectionTypeLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(DETECTION_TYPE_NONE);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelPeak = new Label(composite, 0);
        this.labelPeak.setText(DETECTION_TYPE_NONE);
        this.labelPeak.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText(DETECTION_TYPE_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakChartUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createDetectionTypeTangentButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Use Tangent Skim.");
        button.setText(DETECTION_TYPE_NONE);
        button.setEnabled(false);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/detectionTypeTangent.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakChartUI.this.setDetectionType(ExtendedPeakChartUI.DETECTION_TYPE_TANGENT);
            }
        });
        return button;
    }

    private Button createDetectionTypePerpendicularButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Use Perpendicular Drop.");
        button.setText(DETECTION_TYPE_NONE);
        button.setEnabled(false);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/detectionTypePerpendicular.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakChartUI.this.setDetectionType(ExtendedPeakChartUI.DETECTION_TYPE_PERPENDICULAR);
            }
        });
        return button;
    }

    private Button createAddPeakButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(DETECTION_TYPE_NONE);
        button.setToolTipText("Add the splitted peaks.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IChromatogramPeakCSD peakCSD;
                IChromatogramCSD chromatogram;
                if (ExtendedPeakChartUI.this.peak instanceof IChromatogramPeakMSD) {
                    IChromatogramPeakMSD peakMSD = (IChromatogramPeakMSD)ExtendedPeakChartUI.this.peak;
                    IChromatogramMSD chromatogram2 = peakMSD.getChromatogram();
                    if (chromatogram2 != null) {
                        ExtendedPeakChartUI.this.addPeaks((IChromatogram)chromatogram2, ExtendedPeakChartUI.this.peak, ExtendedPeakChartUI.this.peakSplitted1, ExtendedPeakChartUI.this.peakSplitted2);
                        ExtendedPeakChartUI.this.peak = ExtendedPeakChartUI.this.peakSplitted1;
                        ExtendedPeakChartUI.this.resetSplittedPeaks();
                        ExtendedPeakChartUI.this.setDetectionType(ExtendedPeakChartUI.DETECTION_TYPE_NONE);
                        ExtendedPeakChartUI.this.updatePeaks();
                    }
                } else if (ExtendedPeakChartUI.this.peak instanceof IChromatogramPeakCSD && (chromatogram = (peakCSD = (IChromatogramPeakCSD)ExtendedPeakChartUI.this.peak).getChromatogram()) != null) {
                    ExtendedPeakChartUI.this.addPeaks((IChromatogram)chromatogram, ExtendedPeakChartUI.this.peak, ExtendedPeakChartUI.this.peakSplitted1, ExtendedPeakChartUI.this.peakSplitted2);
                    ExtendedPeakChartUI.this.peak = ExtendedPeakChartUI.this.peakSplitted1;
                    ExtendedPeakChartUI.this.resetSplittedPeaks();
                    ExtendedPeakChartUI.this.setDetectionType(ExtendedPeakChartUI.DETECTION_TYPE_NONE);
                    ExtendedPeakChartUI.this.updatePeaks();
                }
            }
        });
        return button;
    }

    private void addPeaks(IChromatogram chromatogram, IPeak peakOriginal, IPeak peak1, IPeak peak2) {
        if (peak1 != null || peak2 != null) {
            this.removePeakFromChromatogram(chromatogram, peakOriginal);
            this.addPeakToChromatogram(chromatogram, peak1);
            this.addPeakToChromatogram(chromatogram, peak2);
        }
    }

    private void removePeakFromChromatogram(IChromatogram chromatogram, IPeak peak) {
        if (peak != null) {
            if (chromatogram instanceof IChromatogramMSD && peak instanceof IChromatogramPeakMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                chromatogramMSD.removePeak((IPeak)((IChromatogramPeakMSD)peak));
            } else if (chromatogram instanceof IChromatogramCSD && peak instanceof IChromatogramPeakCSD) {
                IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                chromatogramCSD.removePeak((IPeak)((IChromatogramPeakCSD)peak));
            }
        }
    }

    private void addPeakToChromatogram(IChromatogram chromatogram, IPeak peak) {
        if (peak != null) {
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                chromatogramMSD.addPeak((IPeak)((IChromatogramPeakMSD)peak));
            } else if (chromatogram instanceof IChromatogramCSD) {
                IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                chromatogramCSD.addPeak((IPeak)((IChromatogramPeakCSD)peak));
            }
        }
    }

    private void createToggleChartSeriesLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart series legend.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakChartUI.this.peakChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createToggleLegendMarkerButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend marker.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chartLegendMarker.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IChartSettings chartSettings;
                boolean isShowLegendMarker = (chartSettings = ExtendedPeakChartUI.this.peakChart.getChartSettings()).isShowLegendMarker();
                chartSettings.setShowLegendMarker(!isShowLegendMarker);
                ExtendedPeakChartUI.this.peakChart.applySettings(chartSettings);
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Overlay");
        button.setText(DETECTION_TYPE_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakChartUI.this.setDetectionType(ExtendedPeakChartUI.DETECTION_TYPE_NONE);
                ExtendedPeakChartUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText(DETECTION_TYPE_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePagePeaks()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageScans()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedPeakChartUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void createPeakChart(Composite parent) {
        this.peakChart = new PeakChartUI(parent, 2048);
        this.peakChart.setLayoutData(new GridData(1808));
        IChartSettings chartSettings = this.peakChart.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setShowPositionMarker(true);
        chartSettings.setShowLegendMarker(false);
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(116));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(112));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new MouseDoubleClickEventProcessor());
        this.peakChart.applySettings(chartSettings);
        IPlotArea plotArea = this.getPlotArea();
        this.splitSelectionPaintListener = new SplitSelectionPaintListener();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.splitSelectionPaintListener);
    }

    private void reset() {
        this.resetSplittedPeaks();
        this.updatePeaks();
    }

    private void applySettings() {
        this.updatePeaks();
    }

    private void setDetectionType(String detectionType) {
        this.detectionType = detectionType;
        if (detectionType.equals(DETECTION_TYPE_NONE)) {
            this.resetSelectedRange();
        }
        this.enableButtons(detectionType);
        this.labelDetectionType.setText(this.detectionTypeDescriptions.get(detectionType));
    }

    private void resetSelectedRange() {
        this.xStart = 0;
        this.xStop = 0;
    }

    private void enableButtons(String detectionType) {
        boolean enabled = detectionType.equals(DETECTION_TYPE_NONE);
        this.buttonAddPeak.setEnabled(this.peakSplitted1 != null || this.peakSplitted2 != null);
        this.buttonDetectionTypeTangent.setEnabled(enabled);
        this.buttonDetectionTypePerpendicular.setEnabled(enabled);
    }

    private void handleKeyPressedEvent(Event event) {
        if (this.detectionType.equals(DETECTION_TYPE_NONE)) {
            if (event.keyCode == 116) {
                this.setDetectionType(DETECTION_TYPE_TANGENT);
            } else if (event.keyCode == 112) {
                this.setDetectionType(DETECTION_TYPE_PERPENDICULAR);
            }
        }
    }

    private void handleMouseDoubleClickEvent(Event event) {
        if (this.detectionType.equals(DETECTION_TYPE_TANGENT)) {
            if (this.xStart == 0) {
                this.xStart = event.x;
                this.splitSelectionPaintListener.setX1(event.x);
                this.splitSelectionPaintListener.setY1(event.y);
            } else {
                if (event.x > this.xStart) {
                    this.xStop = event.x;
                } else {
                    this.xStop = this.xStart;
                    this.xStart = event.x;
                }
                this.splitSelectionPaintListener.setX2(event.x);
                this.splitSelectionPaintListener.setY2(event.y);
                this.splitPeak();
            }
        } else if (this.detectionType.equals(DETECTION_TYPE_PERPENDICULAR)) {
            this.xStop = this.xStart = event.x;
            this.splitSelectionPaintListener.setX1(event.x);
            this.splitSelectionPaintListener.setY1(event.y);
            this.splitSelectionPaintListener.setX2(event.x);
            this.splitSelectionPaintListener.setY2(event.y);
            this.splitPeak();
        }
    }

    private void splitPeak() {
        if (this.peak != null) {
            Rectangle rectangle = this.getPlotArea().getBounds();
            int width = rectangle.width;
            double factorWidth = 100.0 / (double)width;
            BaseChart baseChart = this.peakChart.getBaseChart();
            IAxis retentionTime = baseChart.getAxisSet().getXAxis(0);
            Range millisecondsRange = retentionTime.getRange();
            double millisecondsWidth = millisecondsRange.upper - millisecondsRange.lower;
            if (this.xStart == this.xStop) {
                double percentageDrop = factorWidth * (double)this.xStart / 100.0;
                int dropRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageDrop);
                IPeakModel peakModel = this.peak.getPeakModel();
                int startRetentionTime = peakModel.getStartRetentionTime();
                int stopRetentionTime = dropRetentionTime;
                float startAbundance = peakModel.getBackgroundAbundance(startRetentionTime);
                float stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTime);
                this.peakSplitted1 = this.extractPeakByCoordinates(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                startRetentionTime = dropRetentionTime;
                stopRetentionTime = peakModel.getStopRetentionTime();
                startAbundance = peakModel.getBackgroundAbundance(startRetentionTime);
                stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTime);
                this.peakSplitted2 = this.extractPeakByCoordinates(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                if (this.peakSplitted1 != null || this.peakSplitted2 != null) {
                    this.buttonAddPeak.setEnabled(true);
                }
            } else {
                double percentageStartWidth = factorWidth * (double)this.xStart / 100.0;
                double percentageStopWidth = factorWidth * (double)this.xStop / 100.0;
                int startRetentionTimeSkim = (int)(millisecondsRange.lower + millisecondsWidth * percentageStartWidth);
                int stopRetentionTimeSkim = (int)(millisecondsRange.lower + millisecondsWidth * percentageStopWidth);
                IPeakModel peakModel = this.peak.getPeakModel();
                int retentionTimeAtMaximum = peakModel.getRetentionTimeAtPeakMaximum();
                if (startRetentionTimeSkim < retentionTimeAtMaximum && stopRetentionTimeSkim < retentionTimeAtMaximum) {
                    float startAbundance = peakModel.getBackgroundAbundance(startRetentionTimeSkim);
                    float stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTimeSkim);
                    this.peakSplitted1 = this.extractPeakByCoordinates(startRetentionTimeSkim, stopRetentionTimeSkim, startAbundance, stopAbundance);
                    int startRetentionTime = stopRetentionTimeSkim;
                    int stopRetentionTime = peakModel.getStopRetentionTime();
                    startAbundance = peakModel.getBackgroundAbundance(startRetentionTime);
                    stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTime);
                    this.peakSplitted2 = this.extractPeakByCoordinates(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                } else if (startRetentionTimeSkim > retentionTimeAtMaximum && stopRetentionTimeSkim > retentionTimeAtMaximum) {
                    float startAbundance = peakModel.getBackgroundAbundance(startRetentionTimeSkim);
                    float stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTimeSkim);
                    this.peakSplitted1 = this.extractPeakByCoordinates(startRetentionTimeSkim, stopRetentionTimeSkim, startAbundance, stopAbundance);
                    int startRetentionTime = peakModel.getStartRetentionTime();
                    int stopRetentionTime = startRetentionTimeSkim;
                    startAbundance = peakModel.getBackgroundAbundance(startRetentionTime);
                    stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTime);
                    this.peakSplitted2 = this.extractPeakByCoordinates(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                } else {
                    float startAbundance = peakModel.getBackgroundAbundance(startRetentionTimeSkim);
                    float stopAbundance = peakModel.getBackgroundAbundance(stopRetentionTimeSkim);
                    this.peakSplitted1 = this.extractPeakByCoordinates(startRetentionTimeSkim, stopRetentionTimeSkim, startAbundance, stopAbundance);
                    this.peakSplitted2 = null;
                }
                if (this.peakSplitted1 != null) {
                    this.buttonAddPeak.setEnabled(true);
                }
            }
        }
        this.setDetectionType(DETECTION_TYPE_NONE);
        this.updatePeaks();
    }

    private IPeak extractPeakByCoordinates(int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) {
        IChromatogramPeakMSD peakSplitted = null;
        if (this.peak instanceof IChromatogramPeakMSD) {
            try {
                IChromatogramPeakMSD chromatogramPeakMSD = (IChromatogramPeakMSD)this.peak;
                if (chromatogramPeakMSD.getChromatogram() != null) {
                    ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                    IChromatogramMSD chromatogram = chromatogramPeakMSD.getChromatogram();
                    peakSplitted = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                }
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        } else if (this.peak instanceof IChromatogramPeakCSD) {
            try {
                IChromatogramPeakCSD chromatogramPeakCSD = (IChromatogramPeakCSD)this.peak;
                if (chromatogramPeakCSD.getChromatogram() != null) {
                    ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                    IChromatogramCSD chromatogram = chromatogramPeakCSD.getChromatogram();
                    peakSplitted = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                }
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
        return peakSplitted;
    }

    private IPlotArea getPlotArea() {
        return this.peakChart.getBaseChart().getPlotArea();
    }

    private void resetSplittedPeaks() {
        this.peakSplitted1 = null;
        this.peakSplitted2 = null;
        this.buttonAddPeak.setEnabled(false);
        this.splitSelectionPaintListener.reset();
    }

    private class KeyPressedEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private int keyCode;

        public KeyPressedEventProcessor(int keyCode) {
            this.keyCode = keyCode;
        }

        public int getEvent() {
            return 6;
        }

        public int getButton() {
            return this.keyCode;
        }

        public int getStateMask() {
            return 0;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakChartUI.this.handleKeyPressedEvent(event);
        }
    }

    private class MouseDoubleClickEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private MouseDoubleClickEventProcessor() {
        }

        public int getEvent() {
            return 1;
        }

        public int getButton() {
            return 1;
        }

        public int getStateMask() {
            return 0;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakChartUI.this.handleMouseDoubleClickEvent(event);
        }
    }
}

