/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.HeaderDataEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.HeaderDataLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.HeaderDataListFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.HeaderDataTableComparator;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class HeaderDataListUI
extends ExtendedTableViewer {
    private HeaderDataTableComparator headerDataTableComparator = new HeaderDataTableComparator();
    private HeaderDataListFilter headerDataListFilter;
    private IMeasurementInfo measurementInfo;

    public HeaderDataListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.headerDataListFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void setInput(IMeasurementInfo measurementInfo) {
        this.measurementInfo = measurementInfo;
        if (measurementInfo != null) {
            super.setInput((Object)measurementInfo.getHeaderDataMap());
        } else {
            this.clear();
        }
    }

    public void clear() {
        super.setInput(null);
    }

    public void sortTable() {
        int column = 0;
        int sortOrder = -1;
        this.headerDataTableComparator.setColumn(column);
        this.headerDataTableComparator.setDirection(sortOrder);
        this.refresh();
    }

    public IMeasurementInfo getMeasurementInfo() {
        return this.measurementInfo;
    }

    private void createColumns() {
        this.createColumns(HeaderDataLabelProvider.TITLES, HeaderDataLabelProvider.BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)new HeaderDataLabelProvider());
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator((ViewerComparator)this.headerDataTableComparator);
        this.headerDataListFilter = new HeaderDataListFilter();
        this.setFilters(new ViewerFilter[]{this.headerDataListFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals("Value")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new HeaderDataEditingSupport(this, label));
            }
            ++i;
        }
    }
}

