/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.PeaksChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePeaksAxes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakChartSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class QuantPeaksChartUI
extends Composite {
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private PeakChartSupport peakChartSupport = new PeakChartSupport();
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    private PeaksChart peaksChart;
    private IQuantitationCompound quantitationCompound;

    public QuantPeaksChartUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IQuantitationCompound quantitationCompound) {
        this.quantitationCompound = quantitationCompound;
        this.setQuantitationCompound();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(composite);
        this.createPeaksChart(composite);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createToggleChartSeriesLegendButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private void createToggleChartSeriesLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart series legend.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantPeaksChartUI.this.peaksChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the chart");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantPeaksChartUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePagePeaksAxes()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        QuantPeaksChartUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void createPeaksChart(Composite parent) {
        this.peaksChart = new PeaksChart(parent, 0);
        this.peaksChart.setLayoutData(new GridData(1808));
    }

    private void applySettings() {
        this.peaksChart.modifyAxes(true);
        this.setQuantitationCompound();
    }

    private void reset() {
        this.setQuantitationCompound();
    }

    private void setQuantitationCompound() {
        this.peaksChart.deleteSeries();
        if (this.quantitationCompound != null) {
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            int counter = 1;
            IColorScheme colors = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemeDisplayPeaks"));
            boolean enableArea = this.preferenceStore.getBoolean("showAreaDisplayPeaks");
            for (Object object : this.quantitationCompound.getQuantitationPeaks()) {
                if (!(object instanceof IQuantitationPeak)) continue;
                IQuantitationPeak quantitationPeak = (IQuantitationPeak)object;
                StringBuilder builder = new StringBuilder();
                builder.append("P");
                builder.append(counter);
                builder.append(" (");
                builder.append(this.decimalFormat.format(quantitationPeak.getConcentration()));
                builder.append(" ");
                builder.append(quantitationPeak.getConcentrationUnit());
                builder.append(")");
                IPeak peak = quantitationPeak.getReferencePeak();
                ILineSeriesData lineSeriesData = this.peakChartSupport.getPeak(peak, false, false, colors.getColor(), builder.toString());
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setEnableArea(enableArea);
                lineSeriesDataList.add(lineSeriesData);
                ++counter;
                colors.incrementColor();
            }
            this.peaksChart.addSeriesData(lineSeriesDataList, Integer.MAX_VALUE);
        }
    }
}

