/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TargetsLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String VERIFIED_MANUALLY = "Verified (manually)";
    public static final String NAME = "Name";
    public static final String CAS = "CAS";
    public static final String COMMENTS = "Comments";
    public static final String FORMULA = "Formula";
    public static final String SMILES = "SMILES";
    public static final String INCHI = "InChI";
    public static final String CONTRIBUTOR = "Contributor";
    public static final String REFERENCE_ID = "Reference ID";
    public static final String[] TITLES = new String[]{"Verified (manually)", "Rating", "Name", "CAS", "Match Factor", "Reverse Factor", "Match Factor Direct", "Reverse Factor Direct", "Probability", "Formula", "SMILES", "InChI", "Mol Weight", "Advise", "Identifier", "Miscellaneous", "Comments", "Database", "Contributor", "Reference ID", "Retention Time", "Retention Index"};
    public static final int[] BOUNDS = new int[]{30, 30, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IIdentificationTarget) {
                IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
                if (identificationTarget.isManuallyVerified()) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16");
            }
        } else if (columnIndex == 1) {
            if (element instanceof IIdentificationTarget) {
                IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
                float rating = identificationTarget.getComparisonResult().getRating();
                if (rating >= 90.0f) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_up.gif", "16x16");
                }
                if (rating >= 70.0f) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_equal.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_down.gif", "16x16");
            }
        } else if (columnIndex == 2) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IIdentificationTarget) {
            IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
            ILibraryInformation libraryInformation = identificationTarget.getLibraryInformation();
            IComparisonResult comparisonResult = identificationTarget.getComparisonResult();
            switch (columnIndex) {
                case 0: {
                    text = "";
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = libraryInformation.getName();
                    break;
                }
                case 3: {
                    text = libraryInformation.getCasNumber();
                    break;
                }
                case 4: {
                    text = decimalFormat.format(comparisonResult.getMatchFactor());
                    break;
                }
                case 5: {
                    text = decimalFormat.format(comparisonResult.getReverseMatchFactor());
                    break;
                }
                case 6: {
                    text = decimalFormat.format(comparisonResult.getMatchFactorDirect());
                    break;
                }
                case 7: {
                    text = decimalFormat.format(comparisonResult.getReverseMatchFactorDirect());
                    break;
                }
                case 8: {
                    text = decimalFormat.format(comparisonResult.getProbability());
                    break;
                }
                case 9: {
                    text = libraryInformation.getFormula();
                    break;
                }
                case 10: {
                    text = libraryInformation.getSmiles();
                    break;
                }
                case 11: {
                    text = libraryInformation.getInChI();
                    break;
                }
                case 12: {
                    text = decimalFormat.format(libraryInformation.getMolWeight());
                    break;
                }
                case 13: {
                    text = comparisonResult.getAdvise();
                    break;
                }
                case 14: {
                    text = identificationTarget.getIdentifier();
                    break;
                }
                case 15: {
                    text = libraryInformation.getMiscellaneous();
                    break;
                }
                case 16: {
                    text = libraryInformation.getComments();
                    break;
                }
                case 17: {
                    text = libraryInformation.getDatabase();
                    break;
                }
                case 18: {
                    text = libraryInformation.getContributor();
                    break;
                }
                case 19: {
                    text = libraryInformation.getReferenceIdentifier();
                    break;
                }
                case 20: {
                    text = decimalFormat.format((double)libraryInformation.getRetentionTime() / 60000.0);
                    break;
                }
                case 21: {
                    text = decimalFormat.format(libraryInformation.getRetentionIndex());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/targets.gif", "16x16");
        return image;
    }
}

