/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pcr.converter.core.PlateConverterPCR;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PCRImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(PCRImportRunnable.class);
    private File file;
    private IPlate plate = null;

    public PCRImportRunnable(File file) {
        this.file = file;
    }

    public IPlate getPlate() {
        return this.plate;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Plate", -1);
                IProcessingInfo processingInfo = PlateConverterPCR.convert((File)this.file, (IProgressMonitor)monitor);
                this.plate = (IPlate)processingInfo.getProcessingResult();
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

