/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.methods.ListProcessEntryContainer;
import org.eclipse.chemclipse.model.methods.ProcessMethod;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.settings.UserManagement;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.swt.ui.components.IMethodListener;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.editors.EditorSupportFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PreferencesConfig;
import org.eclipse.chemclipse.xxd.process.ui.preferences.PreferencePageChromatogramExport;
import org.eclipse.chemclipse.xxd.process.ui.preferences.PreferencePageReportExport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MethodSupportUI
extends Composite
implements PreferencesConfig {
    private static final Logger logger = Logger.getLogger(MethodSupportUI.class);
    private final ISupplierEditorSupport supplierEditorSupport = new EditorSupportFactory(DataType.MTH).getInstanceEditorSupport();
    private ComboViewer comboViewerMethods;
    private Button buttonAddMethod;
    private Button buttonCopyMethod;
    private Button buttonEditMethod;
    private Button buttonExecuteMethod;
    private Button buttonDeleteMethod;
    private Button buttonMethodDirectory;
    private IMethodListener methodListener = null;

    public MethodSupportUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setMethodListener(IMethodListener methodListener) {
        this.methodListener = methodListener;
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.comboViewerMethods = this.createComboMethod(composite);
        this.buttonAddMethod = this.createButtonAddMethod(composite);
        this.buttonEditMethod = this.createButtonEditMethod(composite);
        this.buttonCopyMethod = this.createButtonCopyMethod(composite);
        this.buttonDeleteMethod = this.createButtonDeleteMethod(composite);
        this.buttonMethodDirectory = this.createButtonMethodDirectory(composite);
        this.buttonExecuteMethod = this.createButtonExecuteMethod(composite);
        this.computeMethodComboItems();
    }

    private ComboViewer createComboMethod(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)new ListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProcessMethod) {
                    return ((IProcessMethod)element).getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a process method.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IProcessMethod) {
                    PreferenceSupplier.setSelectedMethodName((String)((IProcessMethod)object).getName());
                }
                MethodSupportUI.this.enableWidgets();
            }
        });
        return comboViewer;
    }

    private Button createButtonAddMethod(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Creates and adds a new method.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/methodAdd.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.display.getActiveShell();
                File directory = MethodConverter.getUserMethodDirectory();
                if (directory.exists()) {
                    MethodSupportUI.this.createNewMethod(shell, true);
                } else if (MethodSupportUI.this.selectMethodDirectory(shell)) {
                    MethodSupportUI.this.createNewMethod(shell, true);
                } else {
                    MessageDialog.openError((Shell)shell, (String)"Method Editor", (String)"Please select a directory via the settings where your methods are located.");
                }
            }
        });
        return button;
    }

    private Button createButtonEditMethod(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Edit the selected method.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/methodEdit.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = MethodSupportUI.this.comboViewerMethods.getStructuredSelection().getFirstElement();
                File file = MethodSupportUI.this.getProcessMethodFile(object);
                if (file != null) {
                    MethodSupportUI.this.supplierEditorSupport.openEditor(file);
                }
            }
        });
        return button;
    }

    private Button createButtonCopyMethod(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Copy the selected method.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/methodCopy.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object objectSource = MethodSupportUI.this.comboViewerMethods.getStructuredSelection().getFirstElement();
                if (objectSource instanceof IProcessMethod) {
                    IProcessMethod processMethod = (IProcessMethod)objectSource;
                    if (processMethod instanceof ListProcessEntryContainer && ((ListProcessEntryContainer)processMethod).isReadOnly()) {
                        MessageDialog.openInformation((Shell)e.display.getActiveShell(), (String)"Copy Method", (String)"You can't copy this method because it is a method container.");
                        return;
                    }
                    File fileSource = MethodSupportUI.this.getProcessMethodFile(objectSource);
                    if (fileSource != null && fileSource.exists()) {
                        block29: {
                            if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Copy Method", (String)("Do you want to copy the method: " + fileSource.getName() + "?"))) {
                                try {
                                    Throwable throwable = null;
                                    Object var6_8 = null;
                                    try (FileInputStream inputStreamSource = new FileInputStream(fileSource);){
                                        IProcessingInfo processingInfoSource = MethodConverter.load((InputStream)inputStreamSource, (String)fileSource.getAbsolutePath(), null);
                                        IProcessMethod processMethodSource = (IProcessMethod)processingInfoSource.getProcessingResult();
                                        File fileSink = MethodSupportUI.this.createNewMethod(e.display.getActiveShell(), false);
                                        if (fileSink == null || !fileSink.exists()) break block29;
                                        try {
                                            Throwable throwable2 = null;
                                            Object var12_17 = null;
                                            try (FileInputStream inputStreamSink = new FileInputStream(fileSink);){
                                                IProcessingInfo processingInfoSink = MethodConverter.load((InputStream)inputStreamSink, (String)fileSource.getAbsolutePath(), null);
                                                if (processingInfoSink.getProcessingResult() instanceof ProcessMethod) {
                                                    ProcessMethod processMethodSink = (ProcessMethod)processingInfoSink.getProcessingResult();
                                                    for (IProcessEntry processEntry : processMethodSource) {
                                                        processMethodSink.addProcessEntry(processEntry);
                                                    }
                                                    IProcessingInfo processingInfo = MethodConverter.convert((File)fileSink, (IProcessMethod)processMethodSink, (String)"org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.processMethodSupplier", (IProgressMonitor)new NullProgressMonitor());
                                                    if (!processingInfo.hasErrorMessages()) {
                                                        MethodSupportUI.this.computeMethodComboItems();
                                                        MethodSupportUI.this.supplierEditorSupport.openEditor(fileSink);
                                                    }
                                                }
                                            }
                                            catch (Throwable throwable3) {
                                                if (throwable2 == null) {
                                                    throwable2 = throwable3;
                                                } else if (throwable2 != throwable3) {
                                                    throwable2.addSuppressed(throwable3);
                                                }
                                                throw throwable2;
                                            }
                                        }
                                        catch (IOException e1) {
                                            logger.warn((Object)e1);
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable == null) {
                                            throwable = throwable4;
                                        } else if (throwable != throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException e1) {
                                    logger.warn((Object)e1);
                                }
                            }
                        }
                        return;
                    }
                    MessageDialog.openInformation((Shell)e.display.getActiveShell(), (String)"Copy Method", (String)"Can't determine the file for copying, maybe it was already deleted or you don't have sufficient rights?");
                }
            }
        });
        return button;
    }

    private Button createButtonDeleteMethod(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected method.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/methodDelete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = MethodSupportUI.this.comboViewerMethods.getStructuredSelection().getFirstElement();
                if (object instanceof IProcessMethod) {
                    IProcessMethod processMethod = (IProcessMethod)object;
                    if (processMethod instanceof ListProcessEntryContainer && ((ListProcessEntryContainer)processMethod).isReadOnly()) {
                        MessageDialog.openInformation((Shell)e.display.getActiveShell(), (String)"Delete Method", (String)"You can't delete this method because it is read only");
                        return;
                    }
                    File file = MethodSupportUI.this.getProcessMethodFile(object);
                    if (file != null && file.exists()) {
                        if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Delete Method", (String)("Do you want to delete the method: " + file.getName() + "?"))) {
                            file.delete();
                            PreferenceSupplier.setSelectedMethodName((String)"");
                            MethodSupportUI.this.computeMethodComboItems();
                        }
                        return;
                    }
                    MessageDialog.openInformation((Shell)e.display.getActiveShell(), (String)"Delete Method", (String)"Can't determine the file for deletion, maybe it was already deleted or you don't have sufficient rights?");
                }
            }
        });
        return button;
    }

    private Button createButtonExecuteMethod(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Apply the method to the selected chromatogram(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = MethodSupportUI.this.comboViewerMethods.getStructuredSelection().getFirstElement();
                if (object instanceof IProcessMethod) {
                    MethodSupportUI.this.runMethod((IProcessMethod)object, e.display.getActiveShell());
                }
            }
        });
        return button;
    }

    private Button createButtonMethodDirectory(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Select the method directory.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/folder_opened.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodSupportUI.this.selectMethodDirectory(e.display.getActiveShell());
                MethodSupportUI.this.applySettings();
            }
        });
        return button;
    }

    private boolean selectMethodDirectory(Shell shell) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.setText("Method Directory");
        directoryDialog.setFilterPath(MethodConverter.getUserMethodDirectory().getAbsolutePath());
        String directoryPath = directoryDialog.open();
        if (directoryPath != null && !directoryPath.equals("")) {
            MethodConverter.setUserMethodDirectory((File)new File(directoryPath));
            return true;
        }
        return false;
    }

    private File createNewMethod(Shell shell, boolean openEditor) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText("Process Method");
        fileDialog.setFileName("ProcessMethod.ocm");
        fileDialog.setFilterExtensions(MethodConverter.DEFAULT_METHOD_FILE_EXTENSIONS);
        fileDialog.setFilterNames(MethodConverter.DEFAULT_METHOD_FILE_NAMES);
        fileDialog.setFilterPath(MethodConverter.getUserMethodDirectory().getAbsolutePath());
        File file = null;
        String filePath = fileDialog.open();
        if (filePath != null && !filePath.equals("")) {
            file = new File(filePath);
            ProcessMethod processMethod = new ProcessMethod();
            processMethod.setOperator(UserManagement.getCurrentUser());
            processMethod.setDescription("Process Method");
            IProcessingInfo processingInfo = MethodConverter.convert((File)file, (IProcessMethod)processMethod, (String)"org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.processMethodSupplier", (IProgressMonitor)new NullProgressMonitor());
            if (!processingInfo.hasErrorMessages()) {
                PreferenceSupplier.setSelectedMethodName((String)file.getName());
                if (openEditor) {
                    this.computeMethodComboItems();
                    this.supplierEditorSupport.openEditor(file);
                }
            } else {
                file = null;
            }
        }
        return file;
    }

    private void computeMethodComboItems() {
        ArrayList methods = new ArrayList(MethodConverter.getUserMethods());
        if (methods.size() > 0) {
            Collections.sort(methods, new Comparator<IProcessMethod>(){

                @Override
                public int compare(IProcessMethod o1, IProcessMethod o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            this.comboViewerMethods.setInput(methods);
            if (this.comboViewerMethods.getCombo().getItemCount() > 0) {
                this.setSelectedMethod();
            }
        } else {
            this.comboViewerMethods.setInput(null);
        }
        this.enableWidgets();
    }

    private void setSelectedMethod() {
        String selectedMethodName = PreferenceSupplier.getSelectedMethodName();
        Combo combo = this.comboViewerMethods.getCombo();
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getItem(i).equals(selectedMethodName)) {
                combo.select(i);
                break;
            }
            ++i;
        }
        if (combo.getSelectionIndex() == -1) {
            combo.select(0);
            PreferenceSupplier.setSelectedMethodName((String)combo.getItem(0));
        }
    }

    private void runMethod(final IProcessMethod processMethod, Shell shell) {
        if (this.methodListener != null && processMethod != null) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        MethodSupportUI.this.methodListener.execute(processMethod, monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                ProcessingInfoViewSupport.updateProcessingInfoError((String)processMethod.getName(), (String)"Execution failed", (Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void enableWidgets() {
        this.buttonAddMethod.setEnabled(true);
        this.buttonEditMethod.setEnabled(false);
        this.buttonCopyMethod.setEnabled(false);
        this.buttonDeleteMethod.setEnabled(false);
        this.buttonExecuteMethod.setEnabled(false);
        this.buttonMethodDirectory.setEnabled(true);
        Object object = this.comboViewerMethods.getStructuredSelection().getFirstElement();
        if (object instanceof IProcessMethod) {
            boolean editable = this.getProcessMethodFile(object) != null;
            this.buttonEditMethod.setEnabled(editable);
            this.buttonCopyMethod.setEnabled(editable);
            this.buttonDeleteMethod.setEnabled(editable);
            this.buttonExecuteMethod.setEnabled(true);
        }
    }

    private File getProcessMethodFile(Object object) {
        if (object instanceof ProcessMethod) {
            return ((ProcessMethod)object).getSourceFile();
        }
        return null;
    }

    @Override
    public IPreferencePage[] getPreferencePages() {
        PreferencePageReportExport preferencePageReportExport = new PreferencePageReportExport();
        preferencePageReportExport.setTitle("Report Export");
        PreferencePageChromatogramExport preferencePageChromatogramExport = new PreferencePageChromatogramExport();
        preferencePageChromatogramExport.setTitle("Chromatogram Export");
        return new IPreferencePage[]{preferencePageReportExport, preferencePageChromatogramExport};
    }

    @Override
    public void applySettings() {
        this.computeMethodComboItems();
    }
}

