/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;

public class ChromatogramSelectionHandler
implements ICustomSelectionHandler {
    private ExtendedChromatogramUI extendedChromatogramUI;

    public ChromatogramSelectionHandler(ExtendedChromatogramUI extendedChromatogramUI) {
        this.extendedChromatogramUI = extendedChromatogramUI;
    }

    public void handleUserSelection(Event event) {
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection != null) {
            BaseChart baseChart = this.extendedChromatogramUI.getChromatogramChart().getBaseChart();
            Range rangeX = baseChart.getAxisSet().getXAxis(0).getRange();
            Range rangeY = baseChart.getAxisSet().getYAxis(0).getRange();
            int startRetentionTime = (int)rangeX.lower;
            int stopRetentionTime = (int)rangeX.upper;
            float startAbundance = (float)rangeY.lower;
            float stopAbundance = (float)rangeY.upper;
            this.extendedChromatogramUI.setChromatogramSelectionRange(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
        }
    }
}

