/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.filter.IMeasurementFilter;
import org.eclipse.chemclipse.nmr.converter.core.ScanConverterNMR;
import org.eclipse.chemclipse.nmr.model.core.FIDMeasurement;
import org.eclipse.chemclipse.nmr.model.core.FilteredFIDMeasurement;
import org.eclipse.chemclipse.nmr.model.core.FilteredSpectrumMeasurement;
import org.eclipse.chemclipse.nmr.model.core.SpectrumMeasurement;
import org.eclipse.chemclipse.nmr.model.selection.DataNMRSelection;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.processing.filter.FilterContext;
import org.eclipse.chemclipse.processing.filter.Filtered;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.EditorToolBar;
import org.eclipse.chemclipse.support.ui.workbench.PartSupport;
import org.eclipse.chemclipse.ux.extension.ui.editors.IScanEditorNMR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageProcessors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.DynamicSettingsUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedMeasurementResultUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.NMRMeasurementsUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedNMRScanUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScanEditorNMR
extends AbstractDataUpdateSupport
implements IScanEditorNMR,
IDataUpdateSupport {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanEditorNMR";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ScanEditorNMR";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/scan-nmr.gif";
    public static final String TOOLTIP = "NMR Editor";
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(2));
    private final MPart part;
    private final MDirtyable dirtyable;
    private final IEventBroker eventBroker;
    private ExtendedNMRScanUI extendedNMRScanUI;
    private final Shell shell;
    private DataNMRSelection selection;
    private NMRMeasurementsUI measurementsUI;
    private final ProcessorFactory filterFactory;
    private final PartSupport partSupport;
    private ExtendedMeasurementResultUI extendedMeasurementResultUI;
    private ProcessSupplierContext processSupplierContext;

    @Inject
    public ScanEditorNMR(Composite parent, IEventBroker eventBroker, MPart part, MDirtyable dirtyable, Shell shell, ProcessorFactory filterFactory, PartSupport partSupport, ProcessSupplierContext context) {
        super(part);
        this.partSupport = partSupport;
        this.processSupplierContext = context;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScanEditorNMR.this.executorService.shutdownNow();
            }
        });
        this.part = part;
        this.dirtyable = dirtyable;
        this.eventBroker = eventBroker;
        this.shell = shell;
        this.filterFactory = filterFactory;
        this.initialize(parent);
    }

    @Override
    public void registerEvents() {
        this.registerEvent("scan/nmr/update/selection", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        objects.size();
    }

    @Focus
    public void setFocus() {
    }

    @Override
    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.eventBroker.send("scan/nmr/unload/selection", null);
    }

    @Persist
    public void save() {
        this.dirtyable.setDirty(false);
    }

    public boolean saveAs() {
        return true;
    }

    public String getName() {
        return this.part.getLabel();
    }

    public IDataNMRSelection getScanSelection() {
        return this.selection;
    }

    private void initialize(Composite parent) {
        this.createEditorPages(parent);
        this.loadScan();
    }

    private synchronized void loadScan() {
        Object object = this.part.getObject();
        if (object instanceof Map) {
            Map map = (Map)object;
            final File file = new File((String)map.get("File"));
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        final IProcessingInfo convert = ScanConverterNMR.convert((File)file, (IProgressMonitor)monitor);
                        Collection result = (Collection)convert.getProcessingResult();
                        if (result != null) {
                            ScanEditorNMR.this.selection = new DataNMRSelection();
                            for (IComplexSignalMeasurement measurement : result) {
                                ScanEditorNMR.this.selection.addMeasurement(measurement);
                            }
                            for (IComplexSignalMeasurement measurement : result) {
                                if (!(measurement instanceof FIDMeasurement)) continue;
                                ScanEditorNMR.this.selection.setActiveMeasurement(measurement);
                                break;
                            }
                            Display.getDefault().asyncExec(() -> ScanEditorNMR.access$4(ScanEditorNMR.this));
                        } else {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)convert);
                                    ScanEditorNMR.this.partSupport.closePart(ScanEditorNMR.this.part);
                                }
                            });
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (object instanceof IComplexSignalMeasurement) {
            this.selection = new DataNMRSelection();
            String label = ScanEditorNMR.addToSelection((IComplexSignalMeasurement)object, this.selection);
            this.part.setLabel(label);
            Display.getDefault().asyncExec(this::updateSelection);
        }
    }

    private void updateSelection() {
        this.extendedNMRScanUI.update((IDataNMRSelection)this.selection);
        this.measurementsUI.update(this.selection);
    }

    private static String addToSelection(IComplexSignalMeasurement<?> measurement, DataNMRSelection selection) {
        Object filteredObject;
        String name = measurement.getDataName();
        if (measurement instanceof Filtered && (filteredObject = ((Filtered)measurement).getFilterContext().getFilteredObject()) instanceof IComplexSignalMeasurement) {
            name = String.valueOf(ScanEditorNMR.addToSelection((IComplexSignalMeasurement)filteredObject, selection)) + " > " + name;
        }
        selection.addMeasurement(measurement);
        return name;
    }

    private void createEditorPages(Composite parent) {
        Composite container = ControlBuilder.createContainer((Composite)parent);
        this.createToolbar(container);
        SashForm sashForm = new SashForm(container, 256);
        ControlBuilder.maximize((Control)sashForm);
        Composite left = new Composite((Composite)sashForm, 0);
        left.setLayout((Layout)new FillLayout());
        Composite right = new Composite((Composite)sashForm, 0);
        right.setLayout((Layout)new FillLayout());
        sashForm.setWeights(new int[]{800, 200});
        this.extendedNMRScanUI = new ExtendedNMRScanUI(left);
        final Composite composite = new Composite(right, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.measurementsUI = new NMRMeasurementsUI(composite, this.filterFactory, this.processSupplierContext);
        TreeViewer treeViewer = this.measurementsUI.getTreeViewer();
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        final DynamicSettingsUI settingsUI = new DynamicSettingsUI(composite, new GridData(4, 4, true, false));
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FilterContext context;
                Object filteredObject;
                IComplexSignalMeasurement<?> measurement = ScanEditorNMR.this.measurementsUI.getSelection();
                if (measurement instanceof Filtered && (filteredObject = (context = ((Filtered)measurement).getFilterContext()).getFilteredObject()) instanceof IComplexSignalMeasurement) {
                    IComplexSignalMeasurement original = (IComplexSignalMeasurement)filteredObject;
                    settingsUI.setActiveContext(context, new UpdatingObserver(context, measurement, original));
                    composite.layout();
                    return;
                }
                settingsUI.setActiveContext(null, null);
            }
        });
    }

    private EditorToolBar createToolbar(Composite container) {
        EditorToolBar toolBar = new EditorToolBar(container);
        toolBar.addPreferencePages(() -> {
            ArrayList<PreferencePageProcessors> list = new ArrayList<PreferencePageProcessors>();
            list.add(new PreferencePageProcessors(this.processSupplierContext));
            return list;
        }, this::updateSetting);
        toolBar.enableToolbarTextButton(Activator.getDefault().getPreferenceStore(), String.valueOf(this.getClass().getSimpleName()) + ".showToolBarText");
        return toolBar;
    }

    private void updateSetting() {
    }

    static /* synthetic */ void access$4(ScanEditorNMR scanEditorNMR) {
        scanEditorNMR.updateSelection();
    }

    private final class UpdatingObserver<FilteredType, ConfigType>
    implements Observer {
        private final FilterContext<FilteredType, ConfigType> context;
        private final IComplexSignalMeasurement<?> currentMeasurement;
        private IComplexSignalMeasurement<?> originalMeasurement;

        public UpdatingObserver(FilterContext<FilteredType, ConfigType> context, IComplexSignalMeasurement<?> currentMeasurement, IComplexSignalMeasurement<?> originalMeasurement) {
            this.context = context;
            this.currentMeasurement = currentMeasurement;
            this.originalMeasurement = originalMeasurement;
        }

        @Override
        public void update(Observable o, Object arg) {
            if (this.context == null) {
                return;
            }
            Filter filter = this.context.getFilter();
            if (filter instanceof IMeasurementFilter) {
                final IMeasurementFilter measurementFilter = (IMeasurementFilter)filter;
                try {
                    ScanEditorNMR.this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DefaultProcessingResult result = new DefaultProcessingResult();
                                Object config = UpdatingObserver.this.context.getFilterConfig();
                                Collection filterIMeasurements = (Collection)measurementFilter.filterIMeasurements(Collections.singleton(UpdatingObserver.this.originalMeasurement), config, Function.identity(), (MessageConsumer)result, null);
                                if (!filterIMeasurements.isEmpty() && !result.hasErrorMessages()) {
                                    for (IMeasurement measurement : filterIMeasurements) {
                                        Filtered filtered;
                                        if (!(measurement instanceof IComplexSignalMeasurement)) continue;
                                        IComplexSignalMeasurement signalMeasurement = (IComplexSignalMeasurement)measurement;
                                        if (!(measurement instanceof Filtered) || (filtered = (Filtered)measurement).getFilterContext().getFilteredObject() != UpdatingObserver.this.originalMeasurement) continue;
                                        UpdatingObserver.this.copySignals(signalMeasurement, UpdatingObserver.this.currentMeasurement);
                                    }
                                    Display.getDefault().asyncExec(ScanEditorNMR.this.extendedNMRScanUI::updateScan);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        private void copySignals(IComplexSignalMeasurement<?> from, IComplexSignalMeasurement<?> to) {
            if (to instanceof FilteredFIDMeasurement) {
                if (from instanceof FIDMeasurement) {
                    ((FilteredFIDMeasurement)to).setSignals(from.getSignals());
                }
            } else if (to instanceof FilteredSpectrumMeasurement && from instanceof SpectrumMeasurement) {
                ((FilteredSpectrumMeasurement)to).setSignals(from.getSignals());
            }
        }
    }
}

