/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;

public class MethodListLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String[] TITLES = new String[]{"", "Name", "Description", "Type", "Settings", "ID"};
    public static final int[] BOUNDS = new int[]{50, 250, 250, 160, 300, 110};
    private final ProcessSupplierContext processTypeSupport;
    private BiFunction<IProcessEntry, ProcessSupplierContext, ProcessorPreferences<?>> preferencesSupplier;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IProcessEntry) {
                IStatus status = this.validate((IProcessEntry)element);
                if (status.matches(4)) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-error.gif", "16x16");
                }
                if (status.matches(2)) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-warn.gif", "16x16");
                }
                if (status.matches(1)) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-empty.gif", "16x16");
                }
                if (status.isOK()) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/status-ok.gif", "16x16");
                }
            } else {
                if (element instanceof IProcessMethod) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/method.gif", "16x16");
                }
                if (element instanceof ProcessEntryContainer) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/folder_opened.gif", "16x16");
                }
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        IStatus status;
        if (element instanceof IProcessEntry && !(status = this.validate((IProcessEntry)element)).isOK()) {
            return status.getMessage();
        }
        return super.getToolTipText(element);
    }

    public MethodListLabelProvider(ProcessSupplierContext processTypeSupport, BiFunction<IProcessEntry, ProcessSupplierContext, ProcessorPreferences<?>> preferencesSupplier) {
        this.processTypeSupport = processTypeSupport;
        this.preferencesSupplier = preferencesSupplier;
    }

    public String getColumnText(Object element, int columnIndex) {
        block20: {
            block19: {
                if (columnIndex == 0) {
                    return "";
                }
                if (!(element instanceof IProcessEntry)) break block19;
                IProcessEntry entry = (IProcessEntry)element;
                ProcessSupplierContext supplierContext = IProcessEntry.getContext((IProcessEntry)entry, (ProcessSupplierContext)this.processTypeSupport);
                IProcessSupplier supplier = supplierContext.getSupplier(entry.getProcessorId());
                switch (columnIndex) {
                    case 1: {
                        return entry.getName();
                    }
                    case 2: {
                        return entry.getDescription();
                    }
                    case 3: {
                        if (supplier != null) {
                            return Arrays.toString(supplier.getSupportedDataTypes().toArray());
                        }
                        break block20;
                    }
                    case 4: {
                        if (supplier != null) {
                            if (supplier.getSettingsParser().getInputValues().isEmpty() || this.preferencesSupplier == null) {
                                return "not configurable";
                            }
                            ProcessorPreferences<?> preferences = this.preferencesSupplier.apply(entry, supplierContext);
                            if (preferences.isUseSystemDefaults()) {
                                return "defaults";
                            }
                            String text = preferences.getUserSettingsAsString();
                            if (text.startsWith("{")) {
                                text = text.substring(1);
                            }
                            if (text.endsWith("}")) {
                                text = text.substring(0, text.length() - 1);
                            }
                            return text.replace("\"", "");
                        }
                        break block20;
                    }
                    case 5: {
                        return entry.getProcessorId();
                    }
                }
                break block20;
            }
            if (element instanceof ProcessEntryContainer) {
                ProcessEntryContainer method = (ProcessEntryContainer)element;
                switch (columnIndex) {
                    case 1: {
                        return method.getName();
                    }
                    case 2: {
                        return method.getDescription();
                    }
                }
                return "";
            }
        }
        return "n/a";
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/processControl.gif", "16x16");
    }

    private IStatus validate(IProcessEntry processEntry) {
        if (processEntry == null) {
            return ValidationStatus.error((String)"Entry is null");
        }
        ProcessorPreferences preferences = processEntry.getPreferences(IProcessEntry.getContext((IProcessEntry)processEntry, (ProcessSupplierContext)this.processTypeSupport));
        if (preferences == null) {
            return ValidationStatus.error((String)("Processor " + processEntry.getName() + " not avaiable"));
        }
        if (preferences.getSupplier().getSettingsClass() == null) {
            return ValidationStatus.warning((String)("Processor " + processEntry.getName() + " has no settingsclass"));
        }
        if (preferences.isUseSystemDefaults()) {
            return ValidationStatus.info((String)("Processor " + processEntry.getName() + " uses system default settings"));
        }
        try {
            preferences.getUserSettings();
        }
        catch (IOException e) {
            return ValidationStatus.error((String)("Loading settings for Processor " + processEntry.getName() + "failed"), (Throwable)e);
        }
        return ValidationStatus.ok();
    }
}

