/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.support.settings.parser.InputValue;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsUIProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.WidgetItem;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SettingsUI<T>
extends Composite {
    private final SettingsUIProvider.SettingsUIControl control;

    public SettingsUI(Composite parent, ProcessorPreferences<T> preferences) throws IOException {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.control = this.loadSettingsUIProvider(preferences).createUI(this, preferences);
    }

    public void setEnabled(boolean enabled) {
        this.control.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public SettingsUIProvider.SettingsUIControl getControl() {
        return this.control;
    }

    private SettingsUIProvider<T> loadSettingsUIProvider(ProcessorPreferences<T> preferences) {
        try {
            SettingsUIProvider uiProvider;
            Object settings = preferences.getUserSettings();
            if (settings == null && (settings = preferences.getSystemSettings()) == null) {
                settings = preferences.getSupplier().getSettingsParser().createDefaultInstance();
            }
            if ((uiProvider = (SettingsUIProvider)Adapters.adapt((Object)settings, SettingsUIProvider.class)) != null) {
                return uiProvider;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "SettingsUI", "can't get user-settings for processor " + preferences.getSupplier().getId() + " with settingsclass " + preferences.getSupplier().getSettingsClass(), (Throwable)e));
        }
        return new DefaultSettingsUIProvider();
    }

    private static final class DefaultSettingsUIProvider<T>
    implements SettingsUIProvider<T> {
        private DefaultSettingsUIProvider() {
        }

        @Override
        public SettingsUIProvider.SettingsUIControl createUI(Composite parent, ProcessorPreferences<T> preferences) throws IOException {
            return new SettingsUIControlImplementation<T>(parent, preferences);
        }
    }

    private static final class SettingsUIControlImplementation<T>
    implements SettingsUIProvider.SettingsUIControl {
        private final List<WidgetItem> widgetItems = new ArrayList<WidgetItem>();
        private final List<Label> labels = new ArrayList<Label>();
        private final ProcessorPreferences<T> preferences;
        private final Composite container;

        public SettingsUIControlImplementation(Composite parent, ProcessorPreferences<T> preferences) throws IOException {
            this.container = ControlBuilder.createContainer((Composite)parent);
            this.preferences = preferences;
            this.container.setLayout((Layout)new GridLayout(2, false));
            Map valuesMap = preferences.getSerialization().fromString((Collection)preferences.getSupplier().getSettingsParser().getInputValues(), preferences.getUserSettingsAsString());
            if (valuesMap != null) {
                for (Map.Entry entry : valuesMap.entrySet()) {
                    this.widgetItems.add(new WidgetItem((InputValue)entry.getKey(), entry.getValue()));
                }
            }
            if (this.widgetItems.size() > 0) {
                this.createOptionWidgets(this.container);
            } else {
                this.createNoOptionsMessage(this.container);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            for (WidgetItem widgetItem : this.widgetItems) {
                widgetItem.getControl().setEnabled(enabled);
            }
            for (Label label : this.labels) {
                label.setEnabled(enabled);
            }
        }

        private void createOptionWidgets(Composite parent) {
            for (WidgetItem widgetItem : this.widgetItems) {
                Label label = new Label(parent, 0);
                label.setText(widgetItem.getInputValue().getName());
                label.setToolTipText(widgetItem.getInputValue().getDescription());
                GridData data = new GridData(16384, 128, false, false);
                data.verticalIndent = 5;
                data.horizontalIndent = 5;
                label.setLayoutData((Object)data);
                this.labels.add(label);
                widgetItem.initializeControl(parent);
            }
        }

        private void createNoOptionsMessage(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText("This processor offers no options.");
            label.setLayoutData((Object)new GridData(768));
        }

        @Override
        public IStatus validate() {
            for (WidgetItem widgetItem : this.widgetItems) {
                IStatus status = widgetItem.validate();
                if (status.isOK()) continue;
                return status;
            }
            return ValidationStatus.ok();
        }

        @Override
        public String getSettings() throws IOException {
            HashMap<InputValue, Object> values = new HashMap<InputValue, Object>();
            for (WidgetItem widgetItem : this.widgetItems) {
                InputValue inputValue = widgetItem.getInputValue();
                values.put(inputValue, widgetItem.getValue());
            }
            return this.preferences.getSerialization().toString(values);
        }

        @Override
        public void addChangeListener(Listener listener) {
            for (WidgetItem widgetItem : this.widgetItems) {
                Control control = widgetItem.getControl();
                control.addListener(13, listener);
                control.addListener(2, listener);
                control.addListener(4, listener);
                control.addListener(8, listener);
            }
            Event event = new Event();
            event.display = this.container.getShell().getDisplay();
            event.widget = this.container;
            listener.handleEvent(event);
        }

        @Override
        public Control getControl() {
            return this.container;
        }
    }
}

