/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IResponseSignals;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.IEquation;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.CalibrationChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageQuantitationAxes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.CalibrationChartSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;

public class QuantResponseChartUI
extends Composite {
    private CalibrationChartSupport calibrationChartSupport = new CalibrationChartSupport();
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private Composite toolbarInfo;
    private Label labelInfo;
    private CalibrationChart calibrationChart;
    private IQuantitationCompound quantitationCompound;

    public QuantResponseChartUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IQuantitationCompound quantitationCompound) {
        this.quantitationCompound = quantitationCompound;
        this.setQuantitationCompound();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(composite);
        this.toolbarInfo = this.createToolbarInfo(composite);
        this.createCalibrationChart(composite);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createToggleChartSeriesLegendButton(composite);
        this.createToggleLegendMarkerButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)QuantResponseChartUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createToggleChartSeriesLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart series legend.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantResponseChartUI.this.calibrationChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createToggleLegendMarkerButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend marker.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chartLegendMarker.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantResponseChartUI.this.calibrationChart.togglePositionLegendVisibility();
                QuantResponseChartUI.this.calibrationChart.redraw();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the chart");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantResponseChartUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageQuantitationAxes()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        QuantResponseChartUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void createCalibrationChart(Composite parent) {
        this.calibrationChart = new CalibrationChart(parent, 0);
        this.calibrationChart.setLayoutData(new GridData(1808));
    }

    private void applySettings() {
        this.calibrationChart.modifyAxes(true);
        this.setQuantitationCompound();
    }

    private void reset() {
        this.setQuantitationCompound();
    }

    private void setQuantitationCompound() {
        this.labelInfo.setText("");
        this.calibrationChart.deleteSeries();
        if (this.quantitationCompound != null) {
            this.labelInfo.setText("Quantitation Compound: " + this.quantitationCompound.getName());
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            IColorScheme colors = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemeDisplayCalibration"));
            this.calibrationChart.setConcentrationLabel(this.quantitationCompound.getConcentrationUnit());
            boolean useCrossZero = this.quantitationCompound.isCrossZero();
            CalibrationMethod calibrationMethod = this.quantitationCompound.getCalibrationMethod();
            IResponseSignals concentrationResponseEntries = this.quantitationCompound.getResponseSignals();
            Set signals = concentrationResponseEntries.getSignalSet();
            Iterator iterator = signals.iterator();
            while (iterator.hasNext()) {
                double signal = (Double)iterator.next();
                Color color = colors.getColor();
                String label = Double.toString(signal);
                List signalEntries = concentrationResponseEntries.getList(signal);
                ILineSeriesData lineSeriesDataPoints = this.calibrationChartSupport.getLineSeriesData(signalEntries, label, color);
                if (lineSeriesDataPoints != null) {
                    lineSeriesDataList.add(lineSeriesDataPoints);
                    LinearEquation equation = concentrationResponseEntries.getLinearEquation(signal, useCrossZero);
                    Point pointMin = new Point(0.0, 0.0);
                    double x = Arrays.stream(lineSeriesDataPoints.getSeriesData().getXSeries()).max().getAsDouble();
                    double y = Arrays.stream(lineSeriesDataPoints.getSeriesData().getYSeries()).max().getAsDouble();
                    double xMax = x + x / 20.0;
                    double yMax = y + y / 20.0;
                    Point pointMax = new Point(xMax, yMax);
                    ILineSeriesData lineSeriesDataEquation = this.calibrationChartSupport.getLineSeriesData(signalEntries, (IEquation)equation, calibrationMethod, useCrossZero, pointMin, pointMax, label, color);
                    if (lineSeriesDataEquation != null) {
                        lineSeriesDataList.add(lineSeriesDataEquation);
                    }
                }
                colors.incrementColor();
            }
            this.calibrationChart.addSeriesData(lineSeriesDataList, Integer.MAX_VALUE);
        }
    }
}

