/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.custom;

import java.util.Set;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.support.PeakBuilderCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.PeakBuilderMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;

public class PeakDetectorSupport {
    private static final Logger logger = Logger.getLogger(PeakDetectorSupport.class);
    private static final String DESCRIPTION = "Peak Detector (UX)";

    public static IPeak extractPeakByRetentionTime(IChromatogram<? extends IPeak> chromatogram, int startRetentionTime, int stopRetentionTime, boolean includeBackground, boolean optimizeRange, Set<Integer> traces) {
        int startScan = chromatogram.getScanNumber(startRetentionTime);
        int stopScan = chromatogram.getScanNumber(stopRetentionTime);
        return PeakDetectorSupport.extractPeakByScanRange(chromatogram, startScan, stopScan, includeBackground, optimizeRange, traces);
    }

    public static IPeak extractPeakByScanRange(IChromatogram<? extends IPeak> chromatogram, int startScan, int stopScan, boolean includeBackground, boolean optimizeRange, Set<Integer> traces) {
        IChromatogramPeakMSD peak = null;
        try {
            if (startScan > 0 && startScan < stopScan) {
                Object scanRange = optimizeRange ? PeakDetectorSupport.optimizeRange(chromatogram, startScan, stopScan, traces) : new ScanRange(startScan, stopScan);
                if (chromatogram instanceof IChromatogramMSD) {
                    IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                    peak = traces.size() > 0 ? PeakBuilderMSD.createPeak((IChromatogramMSD)chromatogramMSD, (IScanRange)scanRange, (boolean)includeBackground, traces, (IMarkedIons.IonMarkMode)IMarkedIons.IonMarkMode.EXCLUDE) : PeakBuilderMSD.createPeak((IChromatogramMSD)chromatogramMSD, (IScanRange)scanRange, (boolean)includeBackground);
                    peak.setDetectorDescription(DESCRIPTION);
                } else if (chromatogram instanceof IChromatogramCSD) {
                    IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                    peak = PeakBuilderCSD.createPeak((IChromatogramCSD)chromatogramCSD, (IScanRange)scanRange, (boolean)includeBackground);
                    peak.setDetectorDescription(DESCRIPTION);
                } else if (chromatogram instanceof IChromatogramWSD) {
                    logger.info((Object)"Handling WSD data is not supported yet");
                }
            }
        }
        catch (PeakException e) {
            logger.warn((Object)e);
        }
        return peak;
    }

    private static IScanRange optimizeRange(IChromatogram<? extends IPeak> chromatogram, int startScan, int stopScan, Set<Integer> traces) {
        int scanWidth = stopScan - startScan + 1;
        int partLength = scanWidth / 4;
        float maxSignalCenter = Float.MIN_VALUE;
        int centerScan = startScan;
        int i = startScan + partLength;
        while (i <= stopScan - partLength) {
            float signal = PeakDetectorSupport.getScanSignal(chromatogram, i, traces);
            if (signal > maxSignalCenter) {
                maxSignalCenter = signal;
                centerScan = i;
            }
            ++i;
        }
        float minSignalLeft = Float.MAX_VALUE;
        int startScanOptimized = startScan;
        int i2 = startScan;
        while (i2 < centerScan) {
            float signal = PeakDetectorSupport.getScanSignal(chromatogram, i2, traces);
            if (signal < minSignalLeft) {
                minSignalLeft = signal;
                startScanOptimized = i2;
            }
            ++i2;
        }
        float minSignalRight = Float.MAX_VALUE;
        int stopScanOptimized = stopScan;
        int i3 = stopScan;
        while (i3 > centerScan) {
            float signal = PeakDetectorSupport.getScanSignal(chromatogram, i3, traces);
            if (signal < minSignalRight) {
                minSignalRight = signal;
                stopScanOptimized = i3;
            }
            --i3;
        }
        return new ScanRange(startScanOptimized, stopScanOptimized);
    }

    private static float getScanSignal(IChromatogram<? extends IPeak> chromatogram, int scanNumber, Set<Integer> traces) {
        float scanSignal = 0.0f;
        IScan scan = chromatogram.getScan(scanNumber);
        if (scan instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)scan;
            IExtractedIonSignal extractedIonSignal = scanMSD.getExtractedIonSignal();
            for (int trace : traces) {
                scanSignal += extractedIonSignal.getAbundance(trace);
            }
        } else {
            scanSignal = scan.getTotalSignal();
        }
        return scanSignal;
    }
}

