/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.fieldeditors;

import java.util.ArrayList;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ColorCodeDialog;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCode;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCodes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ColorCodeTableUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColorCodesFieldEditor
extends FieldEditor {
    private static final int NUMBER_COLUMNS = 2;
    private Composite composite;
    private ColorCodes colorCodes = new ColorCodes();
    private ColorCodeTableUI colorCodeTableUI;

    public ColorCodesFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        this.createLabelSection(this.composite);
        this.createTableSection(this.composite);
        this.createButtonGroup(this.composite);
    }

    private void createLabelSection(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("Add/Remove Color Codes");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createTableSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.colorCodeTableUI = new ColorCodeTableUI(composite, 67586);
        this.setTableViewerInput();
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.setButtonLayoutData(this.createButtonAdd(composite));
        this.setButtonLayoutData(this.createButtonEdit(composite));
        this.setButtonLayoutData(this.createButtonRemove(composite));
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add");
        button.setToolTipText("Add a color code.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorCode colorCode;
                ColorCodeDialog dialog = new ColorCodeDialog(e.display.getActiveShell());
                if (dialog.open() == 0 && (colorCode = dialog.getColorCode()) != null) {
                    ColorCodesFieldEditor.this.colorCodes.add(colorCode);
                    ColorCodesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonEdit(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Edit");
        button.setToolTipText("Edit the selected color code.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = (IStructuredSelection)ColorCodesFieldEditor.this.colorCodeTableUI.getSelection();
                Object object = structuredSelection.getFirstElement();
                if (object instanceof ColorCode) {
                    ColorCode colorCode = (ColorCode)object;
                    ColorCodeDialog dialog = new ColorCodeDialog(e.display.getActiveShell(), colorCode);
                    if (dialog.open() == 0 && (colorCode = dialog.getColorCode()) != null) {
                        ColorCodesFieldEditor.this.colorCodes.add(colorCode);
                        ColorCodesFieldEditor.this.setTableViewerInput();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove");
        button.setToolTipText("Remove the selected color code(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Color Code(s)", (String)"Do you want to delete the selected color code(s)?")) {
                    ArrayList<String> removeKeys = new ArrayList<String>();
                    IStructuredSelection structuredSelection = (IStructuredSelection)ColorCodesFieldEditor.this.colorCodeTableUI.getSelection();
                    Object[] objectArray = structuredSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof ColorCode) {
                            ColorCode colorCode = (ColorCode)object;
                            removeKeys.add(colorCode.getName());
                        }
                        ++n2;
                    }
                    for (String key : removeKeys) {
                        ColorCodesFieldEditor.this.colorCodes.remove(key);
                    }
                    ColorCodesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private void setTableViewerInput() {
        this.colorCodeTableUI.setInput(this.colorCodes.values());
    }

    protected void doLoad() {
        String codes = this.getPreferenceStore().getString(this.getPreferenceName());
        this.colorCodes.load(codes);
        this.setTableViewerInput();
    }

    protected void doLoadDefault() {
        String codes = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.colorCodes.loadDefault(codes);
        this.setTableViewerInput();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.colorCodes.save());
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gridData = (GridData)this.composite.getLayoutData();
        gridData.horizontalSpan = numColumns - 1;
        gridData.grabExcessHorizontalSpace = gridData.horizontalSpan == 1;
    }
}

