/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.ranges;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.ranges.TimeRangeValidator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TimeSpinner
extends Composite {
    private static final int STEP_RETENTION_TIME = 1000;
    private Label label;
    private Label spacer;
    private Text text;
    private Button buttonDecrease;
    private Button buttonIncrease;
    private TimeRange.Marker marker;
    private TimeRange timeRange = null;
    private IUpdateListener updateListener = null;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public TimeSpinner(Composite parent, int style, TimeRange.Marker marker) {
        super(parent, style);
        this.marker = marker;
        this.createControl();
        this.updateDescriptions();
    }

    public void update() {
        super.update();
        this.updateLabel();
    }

    public void setUpdateListener(IUpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public void update(TimeRange timeRange) {
        this.timeRange = timeRange;
        boolean enabled = timeRange != null;
        this.text.setEnabled(enabled);
        this.text.setText(enabled ? this.extractRetentionTime() : "");
        this.buttonDecrease.setEnabled(enabled);
        this.buttonIncrease.setEnabled(enabled);
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.setLayout((Layout)gridLayout);
        this.label = this.createInfo(this);
        this.spacer = this.createSpacer(this);
        this.text = this.createText(this);
        this.buttonDecrease = this.createButtonModify(this, false);
        this.buttonIncrease = this.createButtonModify(this, true);
        this.updateLabel();
    }

    private Label createInfo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000000;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Label createSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Text createText(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText("");
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        final TimeRangeValidator validator = new TimeRangeValidator(this.marker);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (TimeSpinner.this.timeRange != null && TimeSpinner.this.isEnterPressed(e)) {
                    validator.setTimeRange(TimeSpinner.this.timeRange);
                    if (TimeSpinner.this.validate(validator, controlDecoration, text)) {
                        TimeSpinner.this.updateRetentionTime(validator.getRetentionTime());
                        TimeSpinner.this.fireUpdate();
                    }
                }
            }
        });
        return text;
    }

    private Button createButtonModify(Composite parent, final boolean increase) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(String.valueOf(increase ? "Increase" : "Decrease") + " the current time [min].");
        button.setImage(ApplicationImageFactory.getInstance().getImage(increase ? "org.eclipse.chemclipse.rcp.ui.icons/valueIncrease.gif" : "org.eclipse.chemclipse.rcp.ui.icons/valueDecrease.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TimeSpinner.this.timeRange != null) {
                    TimeSpinner.this.updateRetentionTime(increase);
                    TimeSpinner.this.fireUpdate();
                }
            }
        });
        return button;
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText());
        if (status.isOK()) {
            controlDecoration.hide();
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        return false;
    }

    private void fireUpdate() {
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    private boolean isEnterPressed(KeyEvent e) {
        return e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050;
    }

    private void updateRetentionTime(boolean increase) {
        assert (this.marker != null);
        assert (this.timeRange != null);
        int retentionTime = 0;
        switch (this.marker) {
            case START: {
                retentionTime = this.adjustTime(this.timeRange.getStart(), increase);
                break;
            }
            case CENTER: {
                retentionTime = this.adjustTime(this.timeRange.getCenter(), increase);
                break;
            }
            case STOP: {
                retentionTime = this.adjustTime(this.timeRange.getStop(), increase);
            }
        }
        this.updateRetentionTime(retentionTime);
    }

    private void updateRetentionTime(int retentionTime) {
        assert (this.marker != null);
        assert (this.timeRange != null);
        assert (this.text != null);
        switch (this.marker) {
            case START: {
                this.timeRange.updateStart(retentionTime);
                break;
            }
            case CENTER: {
                this.timeRange.updateCenter(retentionTime);
                break;
            }
            case STOP: {
                this.timeRange.updateStop(retentionTime);
            }
        }
        this.text.setText(this.extractRetentionTime());
    }

    private void updateDescriptions() {
        assert (this.marker != null);
        assert (this.text != null);
        String description = "";
        switch (this.marker) {
            case START: {
                description = "Start Time [min]";
                break;
            }
            case CENTER: {
                description = "Center Time [min]";
                break;
            }
            case STOP: {
                description = "Stop Time [min]";
            }
        }
        this.label.setText(description);
        this.text.setToolTipText(description);
    }

    private String extractRetentionTime() {
        assert (this.marker != null);
        assert (this.timeRange != null);
        String retentionTime = "";
        switch (this.marker) {
            case START: {
                retentionTime = this.getRetentionTimeMinutes(this.timeRange.getStart());
                break;
            }
            case CENTER: {
                retentionTime = this.getRetentionTimeMinutes(this.timeRange.getCenter());
                break;
            }
            case STOP: {
                retentionTime = this.getRetentionTimeMinutes(this.timeRange.getStop());
            }
        }
        return retentionTime;
    }

    private int adjustTime(int time, boolean increase) {
        if (increase) {
            return time + 1000;
        }
        int adjustedTime = time - 1000;
        return adjustedTime < 0 ? 0 : adjustedTime;
    }

    private String getRetentionTimeMinutes(int milliseconds) {
        return this.decimalFormat.format((float)milliseconds / 60000.0f);
    }

    private void updateLabel() {
        boolean visible = this.preferenceStore.getBoolean("showTimeRangeSpinnerLabel");
        PartSupport.setControlVisibility((Control)this.label, (boolean)visible);
        PartSupport.setControlVisibility((Control)this.spacer, (boolean)visible);
    }
}

