/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class OverviewChartUI
extends LineChart {
    public OverviewChartUI(Composite parent, int style) {
        super(parent, style);
        this.setBackground(DisplayUtils.getDisplay().getSystemColor(1));
        try {
            this.initialize();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initialize() throws Exception {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setRestrictZoom(false);
        rangeRestriction.setZeroX(true);
        rangeRestriction.setZeroY(false);
        chartSettings.addHandledEventProcessor(new IHandledEventProcessor(){

            public void handleEvent(BaseChart baseChart, Event event) {
                baseChart.adjustRange(true);
                baseChart.redraw();
            }

            public int getStateMask() {
                return 0;
            }

            public int getEvent() {
                return 1;
            }

            public int getButton() {
                return 1;
            }
        });
        this.setPrimaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("Retention Time (milliseconds)");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setPosition(IAxis.Position.Primary);
        primaryAxisSettingsX.setVisible(false);
        primaryAxisSettingsX.setGridLineStyle(LineStyle.NONE);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsY.setPosition(IAxis.Position.Primary);
        primaryAxisSettingsY.setVisible(false);
        primaryAxisSettingsY.setGridLineStyle(LineStyle.NONE);
    }
}

