/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.pcr.model.core.IChannel;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.pcr.model.core.Position;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.swt.ISelectionHandler;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PCRWell;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PCRPlate
extends Composite {
    private static final String LABEL_DATA = "LABEL_DATA";
    private Map<Position, PCRWell> pcrWells = new HashMap<Position, PCRWell>();
    private IWell well = null;
    private Label wellDetailsLabel;

    public PCRPlate(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void refresh() {
        for (PCRWell pcrWell : this.pcrWells.values()) {
            pcrWell.refresh();
        }
    }

    public IWell getSelectedWell() {
        return this.well;
    }

    public void setPlate(IPlate plate) {
        for (PCRWell pcrWell : this.pcrWells.values()) {
            pcrWell.setWell(null);
        }
        if (plate != null) {
            TreeSet wells = plate.getWells();
            for (IWell well : wells) {
                Position position = well.getPosition();
                PCRWell pcrWell = this.pcrWells.get(position);
                if (pcrWell == null) continue;
                pcrWell.setWell(well);
            }
        }
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(13, true);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createCornerWell(composite);
        int i = 1;
        while (i <= 12) {
            this.createDesciptionWell(composite, Integer.toString(i));
            ++i;
        }
        i = 65;
        while (i <= 72) {
            String row = Character.toString((char)i);
            this.createDesciptionWell(composite, row);
            int j = 1;
            while (j <= 12) {
                Position position = new Position(row, j);
                this.createDataWell(composite, position);
                ++j;
            }
            ++i;
        }
        this.wellDetailsLabel = this.createLabel(composite);
    }

    private void createCornerWell(Composite parent) {
        this.createWell(parent, null, Colors.GRAY, Colors.GRAY, Colors.BLACK, "", "");
    }

    private void createDesciptionWell(Composite parent, String content) {
        this.createWell(parent, null, Colors.WHITE, Colors.WHITE, Colors.BLACK, content, "");
    }

    private void createDataWell(Composite parent, Position position) {
        this.createWell(parent, position, Colors.GRAY, Colors.DARK_GRAY, Colors.BLACK, String.valueOf(position.getRow()) + position.getColumn(), position.toString());
    }

    private void createWell(Composite parent, Position position, Color colorInactive, Color colorActive, Color colorText, String text, String tooltip) {
        final PCRWell pcrWell = new PCRWell(parent, 2048);
        pcrWell.setContent(text, tooltip);
        pcrWell.setLayoutData(new GridData(1808));
        pcrWell.setColors(colorInactive, colorActive, colorText);
        pcrWell.setSelectionHandler(new ISelectionHandler(){

            public void handleEvent() {
                PCRPlate.this.showWellDetails(pcrWell.getWell());
                PCRPlate.this.well = pcrWell.getWell();
                final String topic = PCRPlate.this.well != null ? "well/pcr/update/selection" : "well/pcr/unload/selection";
                pcrWell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IEventBroker eventBroker = Activator.getDefault().getEventBroker();
                        eventBroker.send(topic, PCRPlate.this.well != null ? PCRPlate.this.well : null);
                    }
                });
            }
        });
        pcrWell.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                PCRPlate.this.highlightComposite(pcrWell);
                PCRPlate.this.showWellDetails(pcrWell.getWell());
            }
        });
        if (position != null) {
            this.pcrWells.put(position, pcrWell);
        }
    }

    private Label createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 13;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void showWellDetails(IWell well) {
        if (well == null) {
            this.wellDetailsLabel.setText("");
            this.wellDetailsLabel.setData(LABEL_DATA, null);
        } else {
            Object object = this.wellDetailsLabel.getData(LABEL_DATA);
            if (!well.equals(object)) {
                this.wellDetailsLabel.setData(LABEL_DATA, (Object)well);
                StringBuilder builder = new StringBuilder();
                String sampleSubset = well.getSampleSubset();
                String targetName = well.getTargetName();
                builder.append(well.getSampleId());
                if (!well.isEmptyMeasurement()) {
                    builder.append(" | ");
                    builder.append(sampleSubset.equals("") ? "--" : sampleSubset);
                    builder.append(" | ");
                    builder.append(targetName.equals("") ? "--" : targetName);
                    builder.append(" [ ");
                    this.appendCrossingPointInfo(well, builder);
                    builder.append(" ] ");
                }
                this.wellDetailsLabel.setText(builder.toString());
            }
        }
    }

    private void appendCrossingPointInfo(IWell well, StringBuilder builder) {
        IChannel activeChannel = well.getActiveChannel();
        if (activeChannel == null) {
            Iterator iterator = well.getChannels().values().iterator();
            while (iterator.hasNext()) {
                IChannel channel = (IChannel)iterator.next();
                this.appendChannelCrossingPoint(channel, builder);
                if (!iterator.hasNext()) continue;
                builder.append(" , ");
            }
        } else {
            this.appendChannelCrossingPoint(activeChannel, builder);
        }
    }

    private void appendChannelCrossingPoint(IChannel channel, StringBuilder builder) {
        if (channel != null) {
            IPoint crossingPoint = channel.getCrossingPoint();
            if (crossingPoint != null && crossingPoint.getX() > 0.0) {
                DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();
                builder.append(decimalFormat.format(crossingPoint.getX()));
            } else {
                builder.append("--");
            }
        }
    }

    private void highlightComposite(PCRWell pcrWellHighlight) {
        for (PCRWell pcrWell : this.pcrWells.values()) {
            if (pcrWell == pcrWellHighlight) {
                pcrWell.setActive();
                continue;
            }
            pcrWell.setInactive();
        }
    }
}

