/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.traces;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.NamedTraceInputValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.TraceValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTrace;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTraces;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NamedTracesUI
extends Composite {
    private static final String TOOLTIP_TEXT = "Enter/modify the traces.";
    private ComboViewer comboViewer;
    private Text textTraces;
    private Button buttonAdd;
    private Button buttonDelete;
    private NamedTraces namedTraces = null;
    private NamedTrace namedTrace = null;
    private IUpdateListener updateListener = null;

    public NamedTracesUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(NamedTraces namedTraces) {
        this.namedTraces = namedTraces;
        this.updateInput(null);
    }

    public void update() {
        super.update();
        this.updateNamedTrace();
    }

    public void setUpdateListener(IUpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public String[] getItems() {
        return this.comboViewer.getCombo().getItems();
    }

    public void select(int index) {
        if (index >= 0 && index < this.getItems().length) {
            this.comboViewer.getCombo().select(index);
            Object object = this.comboViewer.getStructuredSelection().getFirstElement();
            if (object instanceof NamedTrace) {
                this.namedTrace = (NamedTrace)object;
                this.updateNamedTrace();
            }
        }
    }

    public NamedTraces getNamedTraces() {
        return this.namedTraces;
    }

    public NamedTrace getNamedTrace() {
        return this.namedTrace;
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(4, false);
        this.setLayout((Layout)gridLayout);
        this.comboViewer = this.createComboViewer(this);
        this.textTraces = this.createText(this);
        this.buttonAdd = this.createButtonAdd(this);
        this.buttonDelete = this.createButtonDelete(this);
    }

    private ComboViewer createComboViewer(Composite composite) {
        final ComboViewer comboViewer = new ComboViewer(composite, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NamedTrace) {
                    NamedTrace namedTrace = (NamedTrace)element;
                    return namedTrace.getIdentifier();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a named trace.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof NamedTrace) {
                    NamedTracesUI.this.namedTrace = (NamedTrace)object;
                    NamedTracesUI.this.updateNamedTrace();
                    NamedTracesUI.this.fireUpdate();
                }
            }
        });
        return comboViewer;
    }

    private Text createText(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText(TOOLTIP_TEXT);
        text.setLayoutData((Object)new GridData(768));
        final TraceValidator traceValidator = new TraceValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (NamedTracesUI.this.namedTrace != null && NamedTracesUI.this.validate(traceValidator, controlDecoration, text)) {
                    NamedTracesUI.this.namedTrace.setTraces(traceValidator.getTracesAsString());
                    NamedTracesUI.this.fireUpdate();
                }
            }
        });
        return text;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add a new named trace.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog;
                if (NamedTracesUI.this.namedTraces != null && (dialog = new InputDialog(e.display.getActiveShell(), "Named Trace", "Create a new named trace.", "Hydrocarbons | 57 71 85", (IInputValidator)new NamedTraceInputValidator(NamedTracesUI.this.namedTraces.keySet()))).open() == 0) {
                    String item = dialog.getValue();
                    NamedTrace namedTraceNew = NamedTracesUI.this.namedTraces.extractNamedTrace(item);
                    if (namedTraceNew != null) {
                        NamedTracesUI.this.namedTraces.add(namedTraceNew);
                        NamedTracesUI.this.namedTrace = namedTraceNew;
                        NamedTracesUI.this.updateInput(NamedTracesUI.this.namedTrace.getIdentifier());
                        NamedTracesUI.this.fireUpdate();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected named trace.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object;
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Named Trace", (String)"Would you like to delete the selected named trace?") && (object = NamedTracesUI.this.comboViewer.getStructuredSelection().getFirstElement()) instanceof NamedTrace) {
                    NamedTracesUI.this.namedTrace = null;
                    NamedTracesUI.this.namedTraces.remove((NamedTrace)object);
                    NamedTracesUI.this.updateInput(null);
                    NamedTracesUI.this.fireUpdate();
                }
            }
        });
        return button;
    }

    private void updateInput(String identifier) {
        this.namedTrace = null;
        if (this.namedTraces != null) {
            ArrayList<NamedTrace> traces = new ArrayList<NamedTrace>(this.namedTraces.values());
            Collections.sort(traces, (t1, t2) -> t1.getIdentifier().compareTo(t2.getIdentifier()));
            Combo combo = this.comboViewer.getCombo();
            int selectionIndex = combo.getSelectionIndex();
            this.comboViewer.setInput(traces);
            int itemCount = combo.getItemCount();
            if (itemCount > 0) {
                int index = -1;
                if (identifier == null) {
                    index = selectionIndex >= 0 && selectionIndex < itemCount ? selectionIndex : 0;
                } else {
                    int i = 0;
                    while (i < traces.size()) {
                        if (identifier.equals(((NamedTrace)traces.get(i)).getIdentifier())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index >= 0 && index < itemCount) {
                    combo.select(index);
                    this.namedTrace = (NamedTrace)traces.get(index);
                }
            }
            this.buttonAdd.setEnabled(true);
            this.buttonDelete.setEnabled(itemCount > 0);
        } else {
            this.buttonAdd.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.comboViewer.setInput(null);
        }
        this.updateNamedTrace();
    }

    private void updateNamedTrace() {
        this.textTraces.setText(this.namedTrace != null ? this.namedTrace.getTraces() : "");
        this.buttonDelete.setEnabled(this.namedTrace != null);
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText().trim());
        if (status.isOK()) {
            controlDecoration.hide();
            text.setToolTipText(TOOLTIP_TEXT);
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        text.setToolTipText(status.getMessage());
        return false;
    }

    private void fireUpdate() {
        if (this.updateListener != null) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NamedTracesUI.this.updateListener.update();
                }
            });
        }
    }
}

