/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.chromatogram;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramExportSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramConverterWSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Export";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        for (ISupplier supplier : ChromatogramConverterWSD.getInstance().getChromatogramConverterSupport().getExportSupplier()) {
            list.add((IProcessSupplier<?>)new ChromatogramConverterWSDProcessorSupplier(supplier, this));
        }
        return list;
    }

    private static final class ChromatogramConverterWSDProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<ChromatogramExportSettings> {
        private ISupplier supplier;

        public ChromatogramConverterWSDProcessorSupplier(ISupplier supplier, IProcessTypeSupplier parent) {
            super("wsd.export." + supplier.getId(), supplier.getFilterName(), supplier.getDescription(), ChromatogramExportSettings.class, parent, new DataType[]{DataType.WSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, ChromatogramExportSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            File exportFolder;
            if (processSettings == null) {
                processSettings = new ChromatogramExportSettings();
            }
            if ((exportFolder = processSettings.getExportFolder()) == null) {
                messageConsumer.addErrorMessage(this.getName(), "No outputfolder specified and no default configured");
                return chromatogramSelection;
            }
            if (exportFolder.exists() || exportFolder.mkdirs()) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                if (chromatogram instanceof IChromatogramWSD) {
                    File file = processSettings.getExportFileName(this.supplier.getFileExtension(), chromatogram);
                    IProcessingInfo info = ChromatogramConverterWSD.getInstance().convert(file, (IChromatogram)((IChromatogramWSD)chromatogram), this.supplier.getId(), monitor);
                    messageConsumer.addMessages((MessageProvider)info);
                    if (info != null && info.getProcessingResult() != null) {
                        File result = (File)info.getProcessingResult();
                        messageConsumer.addInfoMessage(this.getName(), "Exported data to " + result.getAbsolutePath());
                    }
                } else {
                    messageConsumer.addWarnMessage(this.getName(), "Only WSD Chromatograms supported, skipp processing");
                }
            } else {
                messageConsumer.addErrorMessage(this.getName(), "The specified outputfolder (" + exportFolder.getAbsolutePath() + ") does not exits and can't be created");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

