/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;

public class WavelengthAbundanceComparator
implements Comparator<IScanSignalWSD>,
Serializable {
    private static final long serialVersionUID = 2053994137218915007L;
    private SortOrder sortOrder;

    public WavelengthAbundanceComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public WavelengthAbundanceComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IScanSignalWSD scanSignal1, IScanSignalWSD scanSignal2) {
        int returnValue;
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Float.compare(scanSignal1.getAbundance(), scanSignal2.getAbundance());
                break;
            }
            case DESC: {
                returnValue = Float.compare(scanSignal2.getAbundance(), scanSignal1.getAbundance());
                break;
            }
            default: {
                returnValue = Float.compare(scanSignal1.getAbundance(), scanSignal2.getAbundance());
            }
        }
        return returnValue;
    }
}

