/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.gson.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;

public class JsonIdentificationTarget
extends IdentificationTarget {
    private static final long serialVersionUID = 1L;
    private static final String KEY_TARGET_IDENTIFIER = "identifier";
    private static final String KEY_TARGET_RESULT_MF = "mf";
    private static final String KEY_TARGET_RESULT_RMF = "rmf";
    private static final String KEY_TARGET_RESULT_MFD = "mfd";
    private static final String KEY_TARGET_RESULT_RMFD = "rmfsd";
    private static final String KEY_LIBRARYINFORMATION = "libraryinformation";
    private static final String KEY_LIBRARY_CAS = "cas";
    private static final String KEY_LIBRARY_NAME = "name";

    private JsonIdentificationTarget(ILibraryInformation libraryInformation, IComparisonResult comparisonResult, String identifier) throws ReferenceMustNotBeNullException {
        super(libraryInformation, comparisonResult, identifier);
    }

    public static void writeTargets(JsonWriter writer, Collection<? extends IIdentificationTarget> targets) throws IOException {
        writer.beginArray();
        for (IIdentificationTarget iIdentificationTarget : targets) {
            writer.beginObject();
            writer.name(KEY_TARGET_IDENTIFIER);
            writer.value(iIdentificationTarget.getIdentifier());
            IComparisonResult result = iIdentificationTarget.getComparisonResult();
            writer.name(KEY_TARGET_RESULT_MF);
            writer.value((double)result.getMatchFactor());
            writer.name(KEY_TARGET_RESULT_RMF);
            writer.value((double)result.getReverseMatchFactor());
            writer.name(KEY_TARGET_RESULT_MFD);
            writer.value((double)result.getMatchFactorDirect());
            writer.name(KEY_TARGET_RESULT_RMFD);
            writer.value((double)result.getReverseMatchFactorDirect());
            writer.name(KEY_LIBRARYINFORMATION);
            JsonIdentificationTarget.writeLibraryInformation(writer, iIdentificationTarget.getLibraryInformation());
            writer.endObject();
        }
        writer.endArray();
    }

    public static void readTargets(JsonArray json, Consumer<? super IIdentificationTarget> consumer) {
        for (JsonElement element : json) {
            JsonObject target = element.getAsJsonObject();
            ComparisonResult result = new ComparisonResult(target.get(KEY_TARGET_RESULT_MF).getAsFloat(), target.get(KEY_TARGET_RESULT_RMF).getAsFloat(), target.get(KEY_TARGET_RESULT_MFD).getAsFloat(), target.get(KEY_TARGET_RESULT_RMF).getAsFloat());
            consumer.accept((IIdentificationTarget)new JsonIdentificationTarget(JsonIdentificationTarget.readLibraryInformation(target.get(KEY_LIBRARYINFORMATION)), (IComparisonResult)result, target.get(KEY_TARGET_IDENTIFIER).getAsString()));
        }
    }

    private static ILibraryInformation readLibraryInformation(JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        LibraryInformation information = new LibraryInformation();
        information.setName(object.get(KEY_LIBRARY_NAME).getAsString());
        information.setCasNumber(object.get(KEY_LIBRARY_CAS).getAsString());
        return information;
    }

    private static void writeLibraryInformation(JsonWriter json, ILibraryInformation libraryInformation) throws IOException {
        json.beginObject();
        json.name(KEY_LIBRARY_NAME);
        json.value(libraryInformation.getName());
        json.name(KEY_LIBRARY_CAS);
        json.value(libraryInformation.getCasNumber());
        json.endObject();
    }
}

