/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.zip.internal.converter;

import java.io.File;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.settings.ApplicationSettings;

public class PathHelper {
    private static final Logger logger = Logger.getLogger(PathHelper.class);
    public static final String ZIP_SUPPLIER = "org.eclipse.chemclipse.msd.converter.supplier.zip";
    private static final String IMPORT = "Import";
    private static final String EXPORT = "Export";

    public static File getStoragePathImport() {
        return PathHelper.getStoragePath(IMPORT);
    }

    public static File getStoragePathExport() {
        return PathHelper.getStoragePath(EXPORT);
    }

    private static File getStoragePath(String directory) {
        StringBuilder builder = new StringBuilder();
        builder.append(ApplicationSettings.getSettingsDirectory().getAbsolutePath());
        builder.append(File.separator);
        builder.append(ZIP_SUPPLIER);
        builder.append(File.separator);
        builder.append(directory);
        File file = new File(builder.toString());
        if (!file.exists() && !file.mkdirs()) {
            logger.warn((Object)("The temporarily zip converter directory could not be created: " + file.getAbsolutePath()));
        }
        return file;
    }

    public static void cleanStoragePathImport() {
        File directory = PathHelper.getStoragePath(IMPORT);
        PathHelper.deleteFiles(directory);
    }

    public static void cleanStoragePathExport() {
        File directory = PathHelper.getStoragePath(EXPORT);
        PathHelper.deleteFiles(directory);
    }

    private static void deleteFiles(File directory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                PathHelper.deleteFiles(file);
            } else if (!file.delete()) {
                logger.warn((Object)("The file " + file + "could not be deleted."));
            }
            ++n2;
        }
        if (!directory.delete()) {
            logger.warn((Object)("The directory " + directory + "could not be deleted."));
        }
    }
}

