/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.zip.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDReader;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.xxd.converter.supplier.zip.internal.converter.PathHelper;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramMSDReader {
    private final int BUFFER = 2048;
    private static final Logger logger = Logger.getLogger(ChromatogramReader.class);
    private List<String> chromatogramFileExtensions = new ArrayList<String>();
    private String defaultFileExtension = "";

    public ChromatogramReader() {
        IChromatogramConverterSupport support = ChromatogramConverterMSD.getInstance().getChromatogramConverterSupport();
        for (ISupplier supplier : support.getSupplier()) {
            this.chromatogramFileExtensions.add(supplier.getFileExtension());
        }
        try {
            ISupplier supplier;
            supplier = support.getSupplier("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
            this.defaultFileExtension = supplier.getFileExtension();
        }
        catch (NoConverterAvailableException e) {
            logger.warn((Object)e);
        }
    }

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        File fileChromatogram = this.extractChromatogramFile(file, monitor);
        IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(fileChromatogram, monitor);
        return (IChromatogramMSD)processingInfo.getProcessingResult();
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        File fileChromatogram = this.extractChromatogramFile(file, monitor);
        IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convertOverview(fileChromatogram, monitor);
        return (IChromatogramOverview)processingInfo.getProcessingResult();
    }

    private File extractChromatogramFile(File file, IProgressMonitor monitor) throws IOException {
        File fileChromatogram;
        File destinationDirectory = PathHelper.getStoragePathImport();
        File extractedFile = this.extractFileToLocalDirectory(file, destinationDirectory, monitor);
        if (extractedFile == null) {
            String fileName = this.getFileName(file);
            fileChromatogram = new File(destinationDirectory + File.separator + fileName);
        } else {
            fileChromatogram = extractedFile;
        }
        return fileChromatogram;
    }

    private String getFileName(File file) {
        String fileName = file.getName().endsWith(".zip") ? file.getName().substring(0, file.getName().length() - 4) : String.valueOf(file.getName()) + this.defaultFileExtension;
        return fileName;
    }

    private File extractFileToLocalDirectory(File file, File destinationDirectory, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry;
        File chromatogram = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) {
                if (chromatogram == null) {
                    chromatogram = this.createDir(destinationDirectory, zipEntry);
                    continue;
                }
                this.createDir(destinationDirectory, zipEntry);
                continue;
            }
            if (chromatogram == null) {
                File chromatogramFile = this.extractFile(destinationDirectory, zipEntry, zipInputStream);
                for (String chromatogramFileExtension : this.chromatogramFileExtensions) {
                    if (!chromatogramFile.getAbsolutePath().endsWith(chromatogramFileExtension)) continue;
                    chromatogram = chromatogramFile;
                }
                continue;
            }
            this.extractFile(destinationDirectory, zipEntry, zipInputStream);
        }
        return chromatogram;
    }

    private File createDir(File destinationDirectory, ZipEntry zipEntry) {
        File file = new File(this.getFileName(destinationDirectory, zipEntry));
        file.mkdir();
        return file;
    }

    private String getFileName(File destinationDirectory, ZipEntry zipEntry) {
        return String.valueOf(destinationDirectory.getAbsolutePath()) + File.separator + zipEntry.getName();
    }

    private File extractFile(File destinationDirectory, ZipEntry zipEntry, ZipInputStream zipInputStream) throws IOException {
        int count;
        byte[] data = new byte[2048];
        File file = new File(this.getFileName(destinationDirectory, zipEntry));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
        while ((count = zipInputStream.read(data, 0, 2048)) != -1) {
            bufferedOutputStream.write(data, 0, count);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return file;
    }
}

