/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.util;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public final class PointsUtil {
    private PointsUtil() {
    }

    public static PrecisionPoint rotate(Point point, double angle, Point rotationPoint) {
        PrecisionPoint pPoint = point instanceof PrecisionPoint ? (PrecisionPoint)point : new PrecisionPoint(point);
        PrecisionPoint pRotationPoint = rotationPoint instanceof PrecisionPoint ? (PrecisionPoint)rotationPoint : new PrecisionPoint(rotationPoint);
        return PointsUtil.doRotate(pPoint, angle, pRotationPoint);
    }

    public static PrecisionPoint doRotate(PrecisionPoint point, double angle, PrecisionPoint rotationPoint) {
        assert (point != null) : "Precondition violated: point!=null";
        assert (rotationPoint != null) : "Precondition violated: rotationPoint!=null";
        double trueAngle = Math.toRadians(angle);
        double sin = Math.sin(trueAngle);
        double cos = Math.cos(trueAngle);
        double relX = point.preciseX() - rotationPoint.preciseX();
        double relY = point.preciseY() - rotationPoint.preciseY();
        double temp = relX * cos - relY * sin;
        double y = relX * sin + relY * cos;
        double x = temp;
        return new PrecisionPoint(x + (double)rotationPoint.x, y + (double)rotationPoint.y);
    }

    public static final PointList rotatePoints(PointList points, double angle) {
        PointList newPoints;
        Rectangle newPointBounds;
        Rectangle pointBounds = points.getBounds();
        Point rotationPoint = pointBounds.getCenter();
        if (!rotationPoint.equals((Object)(newPointBounds = (newPoints = PointsUtil.rotatePoints(points, angle, rotationPoint)).getBounds()).getCenter())) {
            Dimension difference = rotationPoint.getCopy().getDifference(newPointBounds.getCenter());
            newPoints.translate(difference.width, difference.height);
        }
        return newPoints;
    }

    public static final PointList rotatePoints(PointList points, double angle, Point center) {
        PointList newPoints = new PointList();
        int i = 0;
        while (i < points.size()) {
            newPoints.addPoint((Point)PointsUtil.rotate(points.getPoint(i), angle, center));
            ++i;
        }
        return newPoints;
    }

    public static final Point flipPointHorizontally(Point point, int center) {
        int newX = 2 * center - point.x;
        return new Point(newX, point.y);
    }

    public static final Point flipPointVertically(Point point, int center) {
        int newY = 2 * center - point.y;
        return new Point(point.x, newY);
    }

    public static final PointList flipPointsHorizontally(PointList points) {
        int centerX = points.getBounds().x + points.getBounds().width / 2;
        return PointsUtil.flipPointsHorizontally(points, centerX);
    }

    public static final PointList flipPointsHorizontally(PointList points, int centerX) {
        PointList newPointList = new PointList();
        int i = 0;
        while (i < points.size()) {
            newPointList.addPoint(PointsUtil.flipPointHorizontally(points.getPoint(i), centerX));
            ++i;
        }
        return newPointList;
    }

    public static final PointList flipPointsVertically(PointList points) {
        int centerY = points.getBounds().y + points.getBounds().height / 2;
        return PointsUtil.flipPointsVertically(points, centerY);
    }

    public static final PointList flipPointsVertically(PointList points, int centerY) {
        PointList newPointList = new PointList();
        int i = 0;
        while (i < points.size()) {
            newPointList.addPoint(PointsUtil.flipPointVertically(points.getPoint(i), centerY));
            ++i;
        }
        return newPointList;
    }

    public static final void scalePoints(PointList points, double widthRatio, double heightRatio) {
        Point p0 = points.getBounds().getLocation();
        int i = 0;
        while (i < points.size()) {
            Point p = points.getPoint(i);
            p.x = (int)((double)(p.x - p0.x) * widthRatio) + p0.x;
            p.y = (int)((double)(p.y - p0.y) * heightRatio) + p0.y;
            points.setPoint(p, i);
            ++i;
        }
    }

    public static PointList scalePointsBySize(PointList points, int width, int height) {
        int targetW = Math.max(1, width);
        int targetH = Math.max(1, height);
        double oldW = points.getBounds().width;
        double oldH = points.getBounds().height;
        double topLeftX = points.getBounds().x;
        double topLeftY = points.getBounds().y;
        if (oldW != (double)targetW || oldH != (double)targetH) {
            PointList newPoints = new PointList();
            int i = 0;
            while (i < points.size()) {
                int x = points.getPoint((int)i).x;
                int y = points.getPoint((int)i).y;
                Point newPoint = new Point(x, y);
                if (oldW > 0.0 && oldH > 0.0) {
                    double oldRelX = ((double)x - topLeftX) / oldW;
                    double oldRelY = ((double)y - topLeftY) / oldH;
                    double newX = topLeftX + oldRelX * (double)targetW;
                    double newY = topLeftY + oldRelY * (double)targetH;
                    int roundedX = (int)Math.round(newX);
                    int roundedY = (int)Math.round(newY);
                    newPoint = new Point(roundedX, roundedY);
                }
                newPoints.addPoint(newPoint);
                ++i;
            }
            return newPoints;
        }
        return points;
    }
}

