/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.vector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.core.ExportSettingsDialog;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.menu.vector.Messages;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.scattercharts.ScatterChart;
import org.eclipse.swtchart.internal.series.LineSeries;

public class SVGExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.svg";
    private static final String NAME = String.valueOf(Messages.getString("SVG")) + "*.svg" + ")";
    private static final String TITLE = Messages.getString("SAVE_AS_SVG");
    private static final String AXIS_X = "x";
    private static final String AXIS_Y = "y";

    public String getName() {
        return NAME;
    }

    public void execute(final Shell shell, final ScrollableChart scrollableChart) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(NAME);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        final String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                final BaseChart baseChart = scrollableChart.getBaseChart();
                final ExportSettingsDialog exportSettingsDialog = new ExportSettingsDialog(fileDialog.getParent(), baseChart);
                exportSettingsDialog.create();
                if (exportSettingsDialog.open() == 0) {
                    final int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                    final int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                    if (indexAxisX >= 0 && indexAxisY >= 0) {
                        try {
                            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(fileDialog.getParent());
                            monitorDialog.run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        try {
                                            monitor.beginTask(Messages.getString("EXPORT_TO_SVG"), -1);
                                            IAxisSettings axisSettingsX = baseChart.getXAxisSettings(indexAxisX);
                                            IAxisScaleConverter axisScaleConverterX = null;
                                            if (axisSettingsX instanceof ISecondaryAxisSettings) {
                                                ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsX;
                                                axisScaleConverterX = secondaryAxisSettings.getAxisScaleConverter();
                                            }
                                            IAxisSettings axisSettingsY = baseChart.getYAxisSettings(indexAxisY);
                                            IAxisScaleConverter axisScaleConverterY = null;
                                            if (axisSettingsY instanceof ISecondaryAxisSettings) {
                                                ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsY;
                                                axisScaleConverterY = secondaryAxisSettings.getAxisScaleConverter();
                                            }
                                            PrintWriter printWriter = null;
                                            try {
                                                try {
                                                    printWriter = new PrintWriter(new File(fileName));
                                                    AxisSettings axisSettings = new AxisSettings();
                                                    axisSettings.setIndexAxisX(indexAxisX);
                                                    axisSettings.setIndexAxisY(indexAxisY);
                                                    axisSettings.setAxisSettingsX(axisSettingsX);
                                                    axisSettings.setAxisScaleConverterX(axisScaleConverterX);
                                                    axisSettings.setAxisSettingsY(axisSettingsY);
                                                    axisSettings.setAxisScaleConverterY(axisScaleConverterY);
                                                    axisSettings.setExportVisibleOnly(exportSettingsDialog.isExportVisibleOnly());
                                                    if (scrollableChart instanceof LineChart) {
                                                        SVGExportHandler.this.printLinePlot(fileName, printWriter, scrollableChart, axisSettings);
                                                    } else if (scrollableChart instanceof BarChart) {
                                                        SVGExportHandler.this.printBarPlot(fileName, printWriter, scrollableChart, axisSettings);
                                                    } else if (scrollableChart instanceof ScatterChart) {
                                                        SVGExportHandler.this.printScatterPlot(fileName, printWriter, scrollableChart, axisSettings);
                                                    }
                                                    MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_OK);
                                                }
                                                catch (FileNotFoundException e) {
                                                    MessageDialog.openError((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                                                    System.out.println(e);
                                                    if (printWriter != null) {
                                                        printWriter.flush();
                                                        printWriter.close();
                                                    }
                                                }
                                            }
                                            finally {
                                                if (printWriter != null) {
                                                    printWriter.flush();
                                                    printWriter.close();
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            monitor.done();
                                        }
                                    }
                                    finally {
                                        monitor.done();
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                e.printStackTrace();
            }
        }
    }

    private void printLinePlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) throws Exception {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        boolean exportVisibleOnly = axisSettings.isExportVisibleOnly();
        DecimalFormat formatX = axisSettingsX.getDecimalFormat();
        DecimalFormat formatY = axisSettingsY.getDecimalFormat();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        String Template = "Template_LineChart.svg";
        try {
            Throwable throwable = null;
            Object var14_16 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(Template)));){
                String line;
                double[] xTicks = baseChart.getAxisSet().getXAxis(axisSettings.getIndexAxisX()).getTick().getTickLabelValues();
                double[] yTicks = baseChart.getAxisSet().getYAxis(axisSettings.getIndexAxisY()).getTick().getTickLabelValues();
                StringBuilder tickX = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path888\"\n                       d=\"m %x-coordinate%,279.77439 v 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n\t\t       id=\"text892\"\n                       y=\"289.01782\"\n                       x=\"%x-coordinate%\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       xml:space=\"preserve\"><tspan\n                         id=\"tspan890\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:center;text-anchor:middle;stroke-width:0.26458332\"\n                         y=\"289.01782\"\n                         x=\"%x-coordinate%\"\n                         sodipodi:role=\"line\">%X01%</tspan></text>");
                StringBuilder tickY = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path1299\"\n                       d=\"m 15.387913,%y-coordinate% h 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n                       xml:space=\"preserve\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       x=\"14.211229\"\n                       y=\"%y-coordinate%\"\n                       id=\"text1303\"><tspan\n                         sodipodi:role=\"line\"\n                         id=\"tspan1301\"\n                         x=\"14.211229\"\n                         y=\"%y-coordinate%\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:end;text-anchor:end;stroke-width:0.26458332\">%Y01%</tspan></text>");
                StringBuilder legend = new StringBuilder("<path\n                   style=\"fill:url(#linearGradient3662);fill-opacity:1;stroke:%COLOR%;stroke-width:0.5;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n                   d=\"m 209.71446,%y1-coordinate% h 20.93268\"\n                   id=\"path1744\"\n                   inkscape:connector-curvature=\"0\" />\n                <text\n                   xml:space=\"preserve\"\n                   style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:'Bold Oblique';-inkscape-font-specification:'Bold Oblique, ';letter-spacing:0px;word-spacing:0px;fill:url(#linearGradient4353);fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                   x=\"230.91121\"\n                   y=\"%y2-coordinate%\"\n                   id=\"text1748\"><tspan\n                     sodipodi:role=\"line\"\n                     id=\"tspan1746\"\n                     x=\"230.91121\"\n                     y=\"%y2-coordinate%\"\n                     style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:4.23333311px;font-family:Arial;-inkscape-font-specification:Arial;fill:url(#linearGradient4353);fill-opacity:1;stroke-width:0.26458332\">%SERIES A%</tspan></text>");
                String regexX = ".*%X-AXIS_TICKS%.*";
                String regexY = ".*%Y-AXIS_TICKS%.*";
                String titleX = ".*%PLACEHOLDER X-AXIS%.*";
                String titleY = ".*%PLACEHOLDER Y-AXIS%.*";
                String data_series = ".*%DATA SERIES%.*";
                String regex_legend = ".*%LEGEND%.*";
                while ((line = in.readLine()) != null) {
                    String string;
                    String match2;
                    String match1;
                    String[] split;
                    StringBuilder out;
                    if (Pattern.matches(regexX, line)) {
                        int ticklabel_size = xTicks.length;
                        double start = 20.306;
                        double height = 286.91;
                        out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                        double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickX.toString().split("\\n");
                            match1 = ".*%x-coordinate%.*";
                            match2 = ".*%X01%.*";
                            double x = start + (xTicks[count] - lower) / (upper - lower) * height;
                            String[] stringArray = split;
                            int n = split.length;
                            int n2 = 0;
                            while (n2 < n) {
                                string = stringArray[n2];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%x-coordinate%", String.valueOf(x));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%X01%", String.valueOf(formatX.format(xTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n2;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexX, out.toString());
                    } else if (Pattern.matches(regexY, line)) {
                        int ticklabel_size = yTicks.length;
                        double start = 279.90709;
                        double height = 200.0;
                        out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                        double lower = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickY.toString().split("\\n");
                            match1 = ".*%y-coordinate%.*";
                            match2 = ".*%Y01%.*";
                            double y = start - (height - (upper - yTicks[count]) / (upper - lower) * height);
                            String[] stringArray = split;
                            int n = split.length;
                            int n3 = 0;
                            while (n3 < n) {
                                string = stringArray[n3];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%y-coordinate%", String.valueOf(y));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%Y01%", String.valueOf(formatY.format(yTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n3;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexY, out.toString());
                    } else if (Pattern.matches(titleX, line)) {
                        line = line.replace("%PLACEHOLDER X-AXIS%", axisSettingsX.getTitle());
                    } else if (Pattern.matches(titleY, line)) {
                        line = line.replace("%PLACEHOLDER Y-AXIS%", axisSettingsY.getTitle());
                    } else if (Pattern.matches(regex_legend, line)) {
                        double start1 = 100.5815;
                        double start2 = 102.06668;
                        String[] color = new String[]{"#000000", "#FF0000", "#0000FF", "#008000", "#808080", "#800080", "#FFFF00", "#A52A2A", "#FFC0CB", "#FFA500"};
                        out = new StringBuilder("");
                        int count = 0;
                        while (count < series.length) {
                            String col = color[count % 10];
                            double y1 = start1 + (double)(6 * count);
                            double y2 = start2 + (double)(6 * count);
                            String des = series[count].getDescription();
                            String[] split2 = legend.toString().split("\\n");
                            String match12 = ".*%y1-coordinate%.*";
                            String match22 = ".*%y2-coordinate%.*";
                            String match3 = ".*%COLOR%.*";
                            String match4 = ".*%SERIES A%.*";
                            String[] stringArray = split2;
                            int n = split2.length;
                            int n4 = 0;
                            while (n4 < n) {
                                String string2 = stringArray[n4];
                                if (Pattern.matches(match12, string2)) {
                                    string2 = string2.replace("%y1-coordinate%", String.valueOf(y1));
                                } else if (Pattern.matches(match22, string2)) {
                                    string2 = string2.replace("%y2-coordinate%", String.valueOf(y2));
                                } else if (Pattern.matches(match3, string2)) {
                                    string2 = string2.replace("%COLOR%", col);
                                } else if (Pattern.matches(match4, string2)) {
                                    string2 = string2.replace("%SERIES A%", des);
                                }
                                out.append(string2);
                                out.append("\n");
                                ++n4;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regex_legend, out.toString());
                    } else if (Pattern.matches(data_series, line)) {
                        StringBuilder out2 = new StringBuilder("");
                        int widthPlotArea = baseChart.getPlotArea().getSize().x;
                        int heightPlotArea = baseChart.getPlotArea().getSize().y;
                        IAxisSet axisSet = baseChart.getAxisSet();
                        int index = 0;
                        ISeries[] iSeriesArray = series;
                        int n = series.length;
                        int n5 = 0;
                        while (n5 < n) {
                            ISeries dataSeries = iSeriesArray[n5];
                            LineSeries lineSeries = (LineSeries)dataSeries;
                            LineStyle lineStyle = lineSeries.getLineStyle();
                            if (dataSeries != null) {
                                StringBuilder string3 = null;
                                if (lineStyle != LineStyle.NONE) {
                                    if (exportVisibleOnly) {
                                        if (dataSeries.isVisible()) {
                                            string3 = this.printLineData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                        }
                                    } else {
                                        string3 = this.printLineData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                    }
                                } else if (exportVisibleOnly) {
                                    if (dataSeries.isVisible()) {
                                        string3 = this.printScatterData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                    }
                                } else {
                                    string3 = this.printScatterData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                }
                                out2.append((CharSequence)string3);
                            }
                            ++n5;
                        }
                        line = line.replaceAll(data_series, out2.toString());
                    }
                    printWriter.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private StringBuilder printLineData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter, IAxisSet axisSet) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<path\n               style=\"fill:none;stroke:%COLOR%;stroke-width:0.45888707;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n               d=\"M %DATA POINTS%\"\n               id=\"path1740\"\n               inkscape:connector-curvature=\"0\" />");
        String[] color = new String[]{"#000000", "#FF0000", "#0000FF", "#008000", "#808080", "#800080", "#FFFF00", "#A52A2A", "#FFC0CB", "#FFA500"};
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%DATA POINTS%.*";
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (Pattern.matches(match1, string)) {
                string = string.replace("%COLOR%", color[index % 10]);
            } else if (Pattern.matches(match2, string)) {
                StringBuilder rep = new StringBuilder("");
                int i = 0;
                while (i < size) {
                    Point point = dataSeries.getPixelCoordinates(i);
                    if (point.x >= 0 && point.x <= widthPlotArea && point.y >= 0 && point.y <= heightPlotArea) {
                        rep.append(this.printValueLinePlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX));
                        rep.append(",");
                        rep.append(this.printValueLinePlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY));
                        rep.append(" ");
                    }
                    ++i;
                }
                string = string.replace("%DATA POINTS%", rep);
            }
            out.append(string);
            out.append("\n");
            ++n2;
        }
        return out;
    }

    private String printValueLinePlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter) {
        String ret = "";
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = 23.5 + (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = 23.5 + (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = 80.0 + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }

    private void printBarPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        boolean exportVisibleOnly = axisSettings.isExportVisibleOnly();
        DecimalFormat formatX = axisSettingsX.getDecimalFormat();
        DecimalFormat formatY = axisSettingsY.getDecimalFormat();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        String Template = "Template_BarChart.svg";
        try {
            Throwable throwable = null;
            Object var14_16 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(Template)));){
                String line;
                double[] xTicks = baseChart.getAxisSet().getXAxis(axisSettings.getIndexAxisX()).getTick().getTickLabelValues();
                double[] yTicks = baseChart.getAxisSet().getYAxis(axisSettings.getIndexAxisY()).getTick().getTickLabelValues();
                StringBuilder tickX = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path888\"\n                       d=\"m %x-coordinate%,279.77439 v 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n\t\t       id=\"text892\"\n                       y=\"289.01782\"\n                       x=\"%x-coordinate%\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       xml:space=\"preserve\"><tspan\n                         id=\"tspan890\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:center;text-anchor:middle;stroke-width:0.26458332\"\n                         y=\"289.01782\"\n                         x=\"%x-coordinate%\"\n                         sodipodi:role=\"line\">%X01%</tspan></text>");
                StringBuilder tickY = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path1299\"\n                       d=\"m 15.387913,%y-coordinate% h 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n                       xml:space=\"preserve\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       x=\"14.211229\"\n                       y=\"%y-coordinate%\"\n                       id=\"text1303\"><tspan\n                         sodipodi:role=\"line\"\n                         id=\"tspan1301\"\n                         x=\"14.211229\"\n                         y=\"%y-coordinate%\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:end;text-anchor:end;stroke-width:0.26458332\">%Y01%</tspan></text>");
                StringBuilder legend = new StringBuilder("<path\n                   style=\"fill:url(#linearGradient3662);fill-opacity:1;stroke:%COLOR%;stroke-width:0.5;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n                   d=\"m 209.71446,%y1-coordinate% h 20.93268\"\n                   id=\"path1744\"\n                   inkscape:connector-curvature=\"0\" />\n                <text\n                   xml:space=\"preserve\"\n                   style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:'Bold Oblique';-inkscape-font-specification:'Bold Oblique, ';letter-spacing:0px;word-spacing:0px;fill:url(#linearGradient4353);fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                   x=\"230.91121\"\n                   y=\"%y2-coordinate%\"\n                   id=\"text1748\"><tspan\n                     sodipodi:role=\"line\"\n                     id=\"tspan1746\"\n                     x=\"230.91121\"\n                     y=\"%y2-coordinate%\"\n                     style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:4.23333311px;font-family:Arial;-inkscape-font-specification:Arial;fill:url(#linearGradient4353);fill-opacity:1;stroke-width:0.26458332\">%SERIES A%</tspan></text>");
                String regexX = ".*%X-AXIS_TICKS%.*";
                String regexY = ".*%Y-AXIS_TICKS%.*";
                String titleX = ".*%PLACEHOLDER X-AXIS%.*";
                String titleY = ".*%PLACEHOLDER Y-AXIS%.*";
                String data_series = ".*%DATA SERIES%.*";
                String regex_legend = ".*%LEGEND%.*";
                while ((line = in.readLine()) != null) {
                    String string;
                    String match2;
                    String match1;
                    String[] split;
                    StringBuilder out;
                    if (Pattern.matches(regexX, line)) {
                        int ticklabel_size = xTicks.length;
                        double start = 20.306;
                        double height = 286.91;
                        out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                        double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickX.toString().split("\\n");
                            match1 = ".*%x-coordinate%.*";
                            match2 = ".*%X01%.*";
                            double x = start + (xTicks[count] - lower) / (upper - lower) * height;
                            String[] stringArray = split;
                            int n = split.length;
                            int n2 = 0;
                            while (n2 < n) {
                                string = stringArray[n2];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%x-coordinate%", String.valueOf(x));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%X01%", String.valueOf(formatX.format(xTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n2;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexX, out.toString());
                    } else if (Pattern.matches(regexY, line)) {
                        int ticklabel_size = yTicks.length;
                        double start = 279.90709;
                        double height = 200.0;
                        out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                        double lower = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickY.toString().split("\\n");
                            match1 = ".*%y-coordinate%.*";
                            match2 = ".*%Y01%.*";
                            double y = start - (height - (upper - yTicks[count]) / (upper - lower) * height);
                            String[] stringArray = split;
                            int n = split.length;
                            int n3 = 0;
                            while (n3 < n) {
                                string = stringArray[n3];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%y-coordinate%", String.valueOf(y));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%Y01%", String.valueOf(formatY.format(yTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n3;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexY, out.toString());
                    } else if (Pattern.matches(titleX, line)) {
                        line = line.replace("%PLACEHOLDER X-AXIS%", axisSettingsX.getTitle());
                    } else if (Pattern.matches(titleY, line)) {
                        line = line.replace("%PLACEHOLDER Y-AXIS%", axisSettingsY.getTitle());
                    } else if (Pattern.matches(regex_legend, line)) {
                        double start1 = 100.5815;
                        double start2 = 102.06668;
                        String[] color = new String[]{"#FF0000", "#000000", "#0000FF", "#008000", "#808080", "#800080", "#FFFF00", "#A52A2A", "#FFC0CB", "#FFA500"};
                        out = new StringBuilder("");
                        int count = 0;
                        while (count < series.length) {
                            String col = color[count % 10];
                            double y1 = start1 + (double)(6 * count);
                            double y2 = start2 + (double)(6 * count);
                            String des = series[count].getDescription();
                            String[] split2 = legend.toString().split("\\n");
                            String match12 = ".*%y1-coordinate%.*";
                            String match22 = ".*%y2-coordinate%.*";
                            String match3 = ".*%COLOR%.*";
                            String match4 = ".*%SERIES A%.*";
                            String[] stringArray = split2;
                            int n = split2.length;
                            int n4 = 0;
                            while (n4 < n) {
                                String string2 = stringArray[n4];
                                if (Pattern.matches(match12, string2)) {
                                    string2 = string2.replace("%y1-coordinate%", String.valueOf(y1));
                                } else if (Pattern.matches(match22, string2)) {
                                    string2 = string2.replace("%y2-coordinate%", String.valueOf(y2));
                                } else if (Pattern.matches(match3, string2)) {
                                    string2 = string2.replace("%COLOR%", col);
                                } else if (Pattern.matches(match4, string2)) {
                                    string2 = string2.replace("%SERIES A%", des);
                                }
                                out.append(string2);
                                out.append("\n");
                                ++n4;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regex_legend, out.toString());
                    } else if (Pattern.matches(data_series, line)) {
                        StringBuilder out2 = new StringBuilder("");
                        int widthPlotArea = baseChart.getPlotArea().getSize().x;
                        int heightPlotArea = baseChart.getPlotArea().getSize().y;
                        IAxisSet axisSet = baseChart.getAxisSet();
                        int index = 0;
                        ISeries[] iSeriesArray = series;
                        int n = series.length;
                        int n5 = 0;
                        while (n5 < n) {
                            ISeries dataSeries = iSeriesArray[n5];
                            if (dataSeries != null) {
                                StringBuilder string3 = null;
                                if (exportVisibleOnly) {
                                    if (dataSeries.isVisible()) {
                                        string3 = this.printBarData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                    }
                                } else {
                                    string3 = this.printBarData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                }
                                out2.append((CharSequence)string3);
                            }
                            ++n5;
                        }
                        line = line.replaceAll(data_series, out2.toString());
                    }
                    printWriter.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private StringBuilder printBarData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter, IAxisSet axisSet) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<rect\n         style=\"opacity:1;fill:%COLOR%;fill-opacity:1;stroke:none;stroke-width:0.96499991;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"\n         id=\"rect901\"\n         width=\"1\"\n         height=\"%height%\"\n         x=\"%x-coordinate%\"\n         y=\"%y-coordinate%\"\n         ry=\"0\" />");
        String[] color = new String[]{"#FF0000", "#000000", "#0000FF", "#008000", "#808080", "#800080", "#FFFF00", "#A52A2A", "#FFC0CB", "#FFA500"};
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%x-coordinate%.*";
        String match3 = ".*%y-coordinate%.*";
        String match4 = ".*%height%.*";
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea) {
                double plotWidthArea;
                double offset = 0.25;
                double x = Double.parseDouble(this.printValueBarPlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX));
                double y = Double.parseDouble(this.printValueBarPlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY));
                double base = Double.parseDouble(this.printValueBarPlot(AXIS_Y, index, printWriter, 0.0, indexAxisY, axisSet, 0, axisScaleConverterY));
                double height = Math.abs(y - base);
                double width = 1.0;
                double newX = x;
                double newY = y;
                double newWidth = width;
                double newHeight = height;
                if (x < 23.5) {
                    newX = -offset;
                    newWidth += x + offset;
                }
                if (y < 80.5) {
                    newY = -offset;
                    newHeight += y + offset;
                }
                if (x + width > (plotWidthArea = 232.0) && (newWidth -= x + width - plotWidthArea + offset) < 0.0) {
                    newWidth = 0.0;
                }
                if (y > base) {
                    if (base + height > y && (newHeight -= base + height - y + offset) < 0.0) {
                        newHeight = 0.0;
                    }
                } else if (y + height > base && (newHeight -= y + height - base + offset) < 0.0) {
                    newHeight = 0.0;
                }
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Pattern.matches(match1, string)) {
                        string = string.replace("%COLOR%", color[index % 10]);
                    } else if (Pattern.matches(match2, string)) {
                        string = string.replace("%x-coordinate%", String.valueOf(newX));
                    } else if (Pattern.matches(match3, string)) {
                        string = ySeries[i] >= 0.0 ? string.replace("%y-coordinate%", String.valueOf(newY)) : string.replace("%y-coordinate%", String.valueOf(base));
                    } else if (Pattern.matches(match4, string)) {
                        string = string.replace("%height%", String.valueOf(newHeight));
                    }
                    out.append(string);
                    out.append("\n");
                    ++n2;
                }
            }
            ++i;
        }
        return out;
    }

    private String printValueBarPlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter) {
        String ret = null;
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = value > xUpper ? xUpper : value;
                value = value < xLower ? xLower : value;
                double x1 = 23.5 + (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = value > yUpper ? yUpper : value;
                value = value < yLower ? yLower : value;
                double y1 = 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = (value = axisScaleConverter.convertToSecondaryUnit(value)) > xUpper ? xUpper : value;
                value = value < xLower ? xLower : value;
                double x1 = 23.5 + (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = (value = axisScaleConverter.convertToSecondaryUnit(value)) > yUpper ? yUpper : value;
                value = value < yLower ? yLower : value;
                double y1 = 80.5 + (yUpper - value) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }

    private void printScatterPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        boolean exportVisibleOnly = axisSettings.isExportVisibleOnly();
        DecimalFormat formatX = axisSettingsX.getDecimalFormat();
        DecimalFormat formatY = axisSettingsY.getDecimalFormat();
        BaseChart baseChart = scrollableChart.getBaseChart();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        String Template = "Template_ScatterChart.svg";
        try {
            Throwable throwable = null;
            Object var14_16 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(Template)));){
                String line;
                double[] xTicks = baseChart.getAxisSet().getXAxis(axisSettings.getIndexAxisX()).getTick().getTickLabelValues();
                double[] yTicks = baseChart.getAxisSet().getYAxis(axisSettings.getIndexAxisY()).getTick().getTickLabelValues();
                StringBuilder tickX = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path888\"\n                       d=\"m %x-coordinate%,279.77439 v 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n\t\t       id=\"text892\"\n                       y=\"289.01782\"\n                       x=\"%x-coordinate%\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       xml:space=\"preserve\"><tspan\n                         id=\"tspan890\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:center;text-anchor:middle;stroke-width:0.26458332\"\n                         y=\"289.01782\"\n                         x=\"%x-coordinate%\"\n                         sodipodi:role=\"line\">%X01%</tspan></text>");
                StringBuilder tickY = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path1299\"\n                       d=\"m 15.387913,%y-coordinate% h 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n                       xml:space=\"preserve\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       x=\"14.211229\"\n                       y=\"%y-coordinate%\"\n                       id=\"text1303\"><tspan\n                         sodipodi:role=\"line\"\n                         id=\"tspan1301\"\n                         x=\"14.211229\"\n                         y=\"%y-coordinate%\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:end;text-anchor:end;stroke-width:0.26458332\">%Y01%</tspan></text>");
                StringBuilder legend = new StringBuilder("<path\n                   style=\"fill:url(#linearGradient3662);fill-opacity:1;stroke:%COLOR%;stroke-width:0.5;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n                   d=\"m 209.71446,%y1-coordinate% h 20.93268\"\n                   id=\"path1744\"\n                   inkscape:connector-curvature=\"0\" />\n                <text\n                   xml:space=\"preserve\"\n                   style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:'Bold Oblique';-inkscape-font-specification:'Bold Oblique, ';letter-spacing:0px;word-spacing:0px;fill:url(#linearGradient4353);fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                   x=\"230.91121\"\n                   y=\"%y2-coordinate%\"\n                   id=\"text1748\"><tspan\n                     sodipodi:role=\"line\"\n                     id=\"tspan1746\"\n                     x=\"230.91121\"\n                     y=\"%y2-coordinate%\"\n                     style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:4.23333311px;font-family:Arial;-inkscape-font-specification:Arial;fill:url(#linearGradient4353);fill-opacity:1;stroke-width:0.26458332\">%SERIES A%</tspan></text>");
                String regexX = ".*%X-AXIS_TICKS%.*";
                String regexY = ".*%Y-AXIS_TICKS%.*";
                String titleX = ".*%PLACEHOLDER X-AXIS%.*";
                String titleY = ".*%PLACEHOLDER Y-AXIS%.*";
                String data_series = ".*%DATA SERIES%.*";
                String regex_legend = ".*%LEGEND%.*";
                while ((line = in.readLine()) != null) {
                    String string;
                    String match2;
                    String match1;
                    String[] split;
                    StringBuilder out;
                    if (Pattern.matches(regexX, line)) {
                        int ticklabel_size = xTicks.length;
                        double start = 20.306;
                        double height = 286.91;
                        out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                        double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickX.toString().split("\\n");
                            match1 = ".*%x-coordinate%.*";
                            match2 = ".*%X01%.*";
                            double x = start + (xTicks[count] - lower) / (upper - lower) * height;
                            String[] stringArray = split;
                            int n = split.length;
                            int n2 = 0;
                            while (n2 < n) {
                                string = stringArray[n2];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%x-coordinate%", String.valueOf(x));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%X01%", String.valueOf(formatX.format(xTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n2;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexX, out.toString());
                    } else if (Pattern.matches(regexY, line)) {
                        int ticklabel_size = yTicks.length;
                        double start = 279.90709;
                        double height = 200.0;
                        out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                        double lower = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickY.toString().split("\\n");
                            match1 = ".*%y-coordinate%.*";
                            match2 = ".*%Y01%.*";
                            double y = start - (height - (upper - yTicks[count]) / (upper - lower) * height);
                            String[] stringArray = split;
                            int n = split.length;
                            int n3 = 0;
                            while (n3 < n) {
                                string = stringArray[n3];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%y-coordinate%", String.valueOf(y));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%Y01%", String.valueOf(formatY.format(yTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n3;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexY, out.toString());
                    } else if (Pattern.matches(titleX, line)) {
                        line = line.replace("%PLACEHOLDER X-AXIS%", axisSettingsX.getTitle());
                    } else if (Pattern.matches(titleY, line)) {
                        line = line.replace("%PLACEHOLDER Y-AXIS%", axisSettingsY.getTitle());
                    } else if (Pattern.matches(regex_legend, line)) {
                        double start1 = 100.5815;
                        double start2 = 102.06668;
                        String[] color = new String[]{"#FF0000", "#000000", "#0000FF", "#008000", "#808080", "#800080", "#FFFF00", "#A52A2A", "#FFC0CB", "#FFA500"};
                        out = new StringBuilder("");
                        int count = 0;
                        while (count < series.length) {
                            String col = color[count % 10];
                            double y1 = start1 + (double)(6 * count);
                            double y2 = start2 + (double)(6 * count);
                            String des = series[count].getDescription();
                            String[] split2 = legend.toString().split("\\n");
                            String match12 = ".*%y1-coordinate%.*";
                            String match22 = ".*%y2-coordinate%.*";
                            String match3 = ".*%COLOR%.*";
                            String match4 = ".*%SERIES A%.*";
                            String[] stringArray = split2;
                            int n = split2.length;
                            int n4 = 0;
                            while (n4 < n) {
                                String string2 = stringArray[n4];
                                if (Pattern.matches(match12, string2)) {
                                    string2 = string2.replace("%y1-coordinate%", String.valueOf(y1));
                                } else if (Pattern.matches(match22, string2)) {
                                    string2 = string2.replace("%y2-coordinate%", String.valueOf(y2));
                                } else if (Pattern.matches(match3, string2)) {
                                    string2 = string2.replace("%COLOR%", col);
                                } else if (Pattern.matches(match4, string2)) {
                                    string2 = string2.replace("%SERIES A%", des);
                                }
                                out.append(string2);
                                out.append("\n");
                                ++n4;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regex_legend, out.toString());
                    } else if (Pattern.matches(data_series, line)) {
                        StringBuilder out2 = new StringBuilder("");
                        int widthPlotArea = baseChart.getPlotArea().getSize().x;
                        int heightPlotArea = baseChart.getPlotArea().getSize().y;
                        IAxisSet axisSet = baseChart.getAxisSet();
                        int index = 0;
                        ISeries[] iSeriesArray = series;
                        int n = series.length;
                        int n5 = 0;
                        while (n5 < n) {
                            ISeries dataSeries = iSeriesArray[n5];
                            if (dataSeries != null) {
                                StringBuilder string3 = null;
                                if (exportVisibleOnly) {
                                    if (dataSeries.isVisible()) {
                                        string3 = this.printScatterData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                    }
                                } else {
                                    string3 = this.printScatterData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet);
                                }
                                out2.append((CharSequence)string3);
                            }
                            ++n5;
                        }
                        line = line.replaceAll(data_series, out2.toString());
                    }
                    printWriter.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private StringBuilder printScatterData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter, IAxisSet axisSet) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<circle\n         style=\"opacity:1;fill:%COLOR%;fill-opacity:1;stroke:none;stroke-width:0.96499991;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"\n         id=\"rect901\"\n\t cx=\"%x-coordinate%\"\n\t cy=\"%y-coordinate%\"\n\t r=\"1\" />");
        String[] color = new String[]{"#FF0000", "#000000", "#0000FF", "#008000", "#808080", "#800080", "#FFFF00", "#A52A2A", "#FFC0CB", "#FFA500"};
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%x-coordinate%.*";
        String match3 = ".*%y-coordinate%.*";
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea && point.y >= 0 && point.y <= heightPlotArea) {
                double x = Double.parseDouble(this.printValueScatterPlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX));
                double y = Double.parseDouble(this.printValueScatterPlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY));
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Pattern.matches(match1, string)) {
                        string = string.replace("%COLOR%", color[index % 10]);
                    } else if (Pattern.matches(match2, string)) {
                        string = string.replace("%x-coordinate%", String.valueOf(x));
                    } else if (Pattern.matches(match3, string)) {
                        string = string.replace("%y-coordinate%", String.valueOf(y));
                    }
                    out.append(string);
                    out.append("\n");
                    ++n2;
                }
            }
            ++i;
        }
        return out;
    }

    private String printValueScatterPlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter) {
        String ret = null;
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = 23.5 + (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = axisScaleConverter.convertToSecondaryUnit(value);
                double x1 = 23.5 + (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = axisScaleConverter.convertToSecondaryUnit(value);
                double y1 = 80.5 + (yUpper - value) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }
}

