/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.AbstractExtendedChart;
import org.eclipse.swtchart.extensions.core.ChartSettings;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartDataCoordinates;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;
import org.eclipse.swtchart.extensions.core.IExtendedChart;
import org.eclipse.swtchart.extensions.core.IKeyboardSupport;
import org.eclipse.swtchart.extensions.core.IRangeSupport;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesModificationListener;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesStatusListener;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.UserSelection;
import org.eclipse.swtchart.extensions.events.IEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class BaseChart
extends AbstractExtendedChart
implements IChartDataCoordinates,
IRangeSupport,
IExtendedChart,
IKeyboardSupport {
    public static final int ID_PRIMARY_X_AXIS = 0;
    public static final int ID_PRIMARY_Y_AXIS = 0;
    public static final String DEFAULT_TITLE_X_AXIS = Messages.getString(Messages.X_AXIS);
    public static final String DEFAULT_TITLE_Y_AXIS = Messages.getString(Messages.Y_AXIS);
    public static final String SELECTED_SERIES_NONE = Messages.getString(Messages.NONE);
    private Map<Integer, Map<Integer, Map<Integer, List<IEventProcessor>>>> registeredEvents;
    private IChartSettings chartSettings = new ChartSettings();
    private static final int MIN_SELECTION_PERCENTAGE = 30;
    public static final long DELTA_CLICK_TIME = 100L;
    private int redrawFrequency = 1;
    private int redrawCounter = 0;
    private List<ICustomSelectionHandler> customRangeSelectionHandlers;
    private List<ICustomSelectionHandler> customPointSelectionHandlers;
    private List<ISeriesModificationListener> seriesModificationListeners;
    private List<ISeriesStatusListener> seriesStatusListeners;
    private UserSelection userSelection = new UserSelection();
    private long clickStartTime;
    private Set<String> selectedSeriesIds;
    private Stack<double[]> handledSelectionEvents;
    private double[] redoSelection;
    public static final int SHIFT_CONSTRAINT_NONE = 0;
    public static final int SHIFT_CONSTRAINT_RANGE_SELECTION = 1;
    public static final int SHIFT_CONSTRAINT_DELETE_X = 2;
    public static final int SHIFT_CONSTRAINT_DELETE_Y = 4;
    public static final int SHIFT_CONSTRAINT_CLINCH_X = 8;
    public static final int SHIFT_CONSTRAINT_STRETCH_X = 16;
    public static final int SHIFT_CONSTRAINT_BROADEN_X = 32;
    public static final int SHIFT_CONSTRAINT_NARROW_X = 64;
    private int shiftConstraints = 0;
    public static final long DELTA_MOVE_TIME = 350L;
    private long moveStartTime = 0L;
    private int xMoveStart = 0;
    private int yMoveStart = 0;
    private Map<String, List<double[]>> dataShiftHistory;

    public BaseChart(Composite parent, int style) {
        super(parent, style);
        this.customRangeSelectionHandlers = new ArrayList<ICustomSelectionHandler>();
        this.customPointSelectionHandlers = new ArrayList<ICustomSelectionHandler>();
        this.seriesModificationListeners = new ArrayList<ISeriesModificationListener>();
        this.seriesStatusListeners = new ArrayList<ISeriesStatusListener>();
        this.selectedSeriesIds = new HashSet<String>();
        this.initializeEventProcessors();
        IAxisSet axisSet = this.getAxisSet();
        IAxis xAxisPrimary = axisSet.getXAxis(0);
        ITitle titleX = xAxisPrimary.getTitle();
        titleX.setText(DEFAULT_TITLE_X_AXIS);
        titleX.setVisible(true);
        xAxisPrimary.setPosition(IAxis.Position.Primary);
        xAxisPrimary.getTick().setFormat((Format)new DecimalFormat());
        xAxisPrimary.enableLogScale(false);
        xAxisPrimary.enableCategory(false);
        xAxisPrimary.setReversed(false);
        xAxisPrimary.setCategorySeries(new String[0]);
        xAxisPrimary.setIntegerDataPointAxis(false);
        IAxis yAxisPrimary = axisSet.getYAxis(0);
        ITitle titleY = yAxisPrimary.getTitle();
        titleY.setText(DEFAULT_TITLE_Y_AXIS);
        titleY.setVisible(true);
        yAxisPrimary.setPosition(IAxis.Position.Primary);
        yAxisPrimary.getTick().setFormat((Format)new DecimalFormat());
        yAxisPrimary.enableLogScale(false);
        yAxisPrimary.enableCategory(false);
        yAxisPrimary.setReversed(false);
        yAxisPrimary.setIntegerDataPointAxis(false);
        this.handledSelectionEvents = new Stack();
        this.redoSelection = null;
        this.dataShiftHistory = new HashMap<String, List<double[]>>();
    }

    private void initializeEventProcessors() {
        this.registeredEvents = new HashMap<Integer, Map<Integer, Map<Integer, List<IEventProcessor>>>>();
        this.initializeEvents();
    }

    private void initializeEvents() {
        this.registeredEvents.put(1, new HashMap());
        this.registeredEvents.put(2, new HashMap());
        this.registeredEvents.put(3, new HashMap());
        this.registeredEvents.put(4, new HashMap());
        this.registeredEvents.put(5, new HashMap());
        this.registeredEvents.put(6, new HashMap());
        this.registeredEvents.put(7, new HashMap());
    }

    public void clearEventProcessors() {
        this.registeredEvents.clear();
        this.initializeEvents();
    }

    public void addEventProcessor(IHandledEventProcessor handledEventProcessor) {
        int stateMask;
        List<IEventProcessor> handledEventProcessors;
        int button;
        Map<Integer, Map<Integer, List<IEventProcessor>>> eventProcessors = this.registeredEvents.get(handledEventProcessor.getEvent());
        Map<Integer, List<IEventProcessor>> buttonEventProcessors = eventProcessors.get(button = handledEventProcessor.getButton());
        if (buttonEventProcessors == null) {
            buttonEventProcessors = new HashMap<Integer, List<IEventProcessor>>();
            eventProcessors.put(button, buttonEventProcessors);
        }
        if ((handledEventProcessors = buttonEventProcessors.get(stateMask = handledEventProcessor.getStateMask())) == null) {
            handledEventProcessors = new ArrayList<IEventProcessor>();
        }
        handledEventProcessors.add(handledEventProcessor);
        buttonEventProcessors.put(stateMask, handledEventProcessors);
    }

    public void setChartSettings(IChartSettings chartSettings) {
        this.chartSettings = chartSettings;
    }

    public IChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public long getMoveStartTime() {
        return this.moveStartTime;
    }

    public void setMoveStartTime(long moveStartTime) {
        this.moveStartTime = moveStartTime;
    }

    public int getXMoveStart() {
        return this.xMoveStart;
    }

    public void setXMoveStart(int xMoveStart) {
        this.xMoveStart = xMoveStart;
    }

    public int getYMoveStart() {
        return this.yMoveStart;
    }

    public void setYMoveStart(int yMoveStart) {
        this.yMoveStart = yMoveStart;
    }

    public UserSelection getUserSelection() {
        return this.userSelection;
    }

    public void increaseRedrawCounter() {
        ++this.redrawCounter;
    }

    public void resetRedrawCounter() {
        this.redrawCounter = 0;
    }

    public long getClickStartTime() {
        return this.clickStartTime;
    }

    public void setClickStartTime(long clickStartTime) {
        this.clickStartTime = clickStartTime;
    }

    public boolean isRedraw() {
        return this.redrawCounter >= this.redrawFrequency;
    }

    public double getShiftValue(int positionStart, int positionStop, String orientation) {
        int length;
        double stop;
        double start;
        IAxis axis;
        double shiftValue = 0.0;
        if (orientation.equals("X_AXIS")) {
            axis = this.getAxisSet().getXAxis(0);
            start = axis.getRange().lower;
            stop = axis.getRange().upper;
            length = this.getPlotArea().getSize().x;
        } else {
            axis = this.getAxisSet().getYAxis(0);
            start = axis.getRange().lower;
            stop = axis.getRange().upper;
            length = this.getPlotArea().getSize().y;
        }
        if (positionStart > 0 && positionStop > 0 && positionStart < length && positionStop < length) {
            double percentageStop;
            double percentageStart;
            double delta = stop - start;
            if (orientation.equals("X_AXIS")) {
                percentageStart = 100.0 / (double)length * (double)positionStart / 100.0;
                percentageStop = 100.0 / (double)length * (double)positionStop / 100.0;
            } else {
                percentageStart = (100.0 - 100.0 / (double)length * (double)positionStart) / 100.0;
                percentageStop = (100.0 - 100.0 / (double)length * (double)positionStop) / 100.0;
            }
            shiftValue = start + delta * percentageStop - (start + delta * percentageStart);
        }
        return shiftValue;
    }

    @Override
    public ISeries<?> createSeries(ISeriesData seriesData, ISeriesSettings seriesSettings) throws SeriesException {
        ISeries<?> series = super.createSeries(seriesData, seriesSettings);
        this.calculateRedrawFrequency();
        return series;
    }

    @Override
    public void deleteSeries(String id) {
        super.deleteSeries(id);
        this.calculateRedrawFrequency();
        this.dataShiftHistory.remove(id);
    }

    @Override
    public void appendSeries(ISeriesData seriesData) {
        super.appendSeries(seriesData);
        this.calculateRedrawFrequency();
    }

    private void calculateRedrawFrequency() {
        this.redrawFrequency = 2;
    }

    public double getSelectedPrimaryAxisValue(int position, String orientation) {
        int length;
        double stop;
        double start;
        IAxis axis;
        double primaryValue = 0.0;
        if (orientation.equals("X_AXIS")) {
            axis = this.getAxisSet().getXAxis(0);
            start = axis.getRange().lower;
            stop = axis.getRange().upper;
            length = this.getPlotArea().getSize().x;
        } else {
            axis = this.getAxisSet().getYAxis(0);
            start = axis.getRange().lower;
            stop = axis.getRange().upper;
            length = this.getPlotArea().getSize().y;
        }
        if (position <= 0) {
            primaryValue = start;
        } else if (position > length) {
            primaryValue = stop;
        } else {
            double delta = stop - start;
            double percentage = orientation.equals("X_AXIS") ? 100.0 / (double)length * (double)position / 100.0 : (100.0 - 100.0 / (double)length * (double)position) / 100.0;
            primaryValue = start + delta * percentage;
        }
        return primaryValue;
    }

    public boolean addCustomRangeSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customRangeSelectionHandlers.add(customSelectionHandler);
    }

    public boolean removeCustomRangeSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customRangeSelectionHandlers.remove(customSelectionHandler);
    }

    public boolean addCustomPointSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customPointSelectionHandlers.add(customSelectionHandler);
    }

    public boolean removeCustomPointSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customPointSelectionHandlers.remove(customSelectionHandler);
    }

    public boolean addSeriesModificationListener(ISeriesModificationListener seriesModificationListener) {
        return this.seriesModificationListeners.add(seriesModificationListener);
    }

    public boolean removeSeriesModificationListener(ISeriesModificationListener seriesModificationListener) {
        return this.seriesModificationListeners.remove(seriesModificationListener);
    }

    public boolean addSeriesStatusListener(ISeriesStatusListener seriesSelectionListener) {
        return this.seriesStatusListeners.add(seriesSelectionListener);
    }

    public boolean removeSeriesStatusListener(ISeriesStatusListener seriesSelectionListener) {
        return this.seriesStatusListeners.remove(seriesSelectionListener);
    }

    public Set<String> getSelectedSeriesIds() {
        return Collections.unmodifiableSet(this.selectedSeriesIds);
    }

    public boolean isSeriesContained(String seriesId) {
        return this.getSeriesSet().getSeries(seriesId) != null;
    }

    @Override
    public void paintControl(PaintEvent e) {
        if (this.userSelection.isActive()) {
            int currentLineStyle = e.gc.getLineStyle();
            e.gc.setLineStyle(3);
            int xMin = Math.min(this.userSelection.getStartX(), this.userSelection.getStopX());
            int xMax = Math.max(this.userSelection.getStartX(), this.userSelection.getStopX());
            int yMin = Math.min(this.userSelection.getStartY(), this.userSelection.getStopY());
            int yMax = Math.max(this.userSelection.getStartY(), this.userSelection.getStopY());
            RangeRestriction rangeRestriction = this.getRangeRestriction();
            if (this.isSelectXY(rangeRestriction)) {
                e.gc.drawRectangle(xMin, yMin, xMax - xMin, yMax - yMin);
            } else if (rangeRestriction.isRestrictSelectX()) {
                e.gc.drawLine(xMin, yMin, xMax, yMin);
            } else if (rangeRestriction.isRestrictSelectY()) {
                e.gc.drawLine(xMin, yMin, xMin, yMax);
            }
            e.gc.setLineStyle(currentLineStyle);
        }
    }

    @Override
    public void handleMouseDownEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(3).get(event.button), event);
    }

    @Override
    public void handleMouseMoveEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(4).get(5), event);
    }

    @Override
    public void handleMouseUpEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(5).get(event.button), event);
    }

    @Override
    public void handleMouseWheel(Event event) {
        this.handleEvent(this.registeredEvents.get(2).get(4), event);
    }

    @Override
    public void handleMouseDoubleClick(Event event) {
        this.handleEvent(this.registeredEvents.get(1).get(event.button), event);
    }

    @Override
    public void handleKeyDownEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(6).get(event.keyCode), event);
    }

    @Override
    public void handleKeyUpEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(7).get(event.keyCode), event);
    }

    private void handleEvent(Map<Integer, List<IEventProcessor>> eventProcessorMap, Event event) {
        if (eventProcessorMap != null) {
            if (event.stateMask == 0) {
                List<IEventProcessor> eventProcessors = eventProcessorMap.get(0);
                this.handleEventProcessors(eventProcessors, event);
            } else {
                for (int eventMask : eventProcessorMap.keySet()) {
                    if (eventMask == 0 || (event.stateMask & eventMask) != eventMask) continue;
                    List<IEventProcessor> eventProcessors = eventProcessorMap.get(eventMask);
                    this.handleEventProcessors(eventProcessors, event);
                    break;
                }
            }
        }
    }

    private void handleEventProcessors(List<IEventProcessor> eventProcessors, Event event) {
        if (eventProcessors != null) {
            for (IEventProcessor eventProcessor : eventProcessors) {
                if (eventProcessor == null) continue;
                eventProcessor.handleEvent(this, event);
            }
        }
    }

    public void selectSeries(String selectedSeriesId) {
        this.selectSeries(selectedSeriesId, true);
    }

    public void selectSeries(String selectedSeriesId, boolean fireUpdate) {
        if (this.isSeriesContained(selectedSeriesId)) {
            ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
            ISeriesSettings seriesSettings = this.getSeriesSettings(selectedSeriesId);
            this.selectedSeriesIds.add(selectedSeriesId);
            this.applySeriesSettings(dataSeries, seriesSettings.getSeriesSettingsHighlight());
            if (fireUpdate) {
                this.fireSeriesStatusEvent(selectedSeriesId, 1);
            }
        }
    }

    public void hideSeries(String selectedSeriesId) {
        this.hideSeries(selectedSeriesId, true);
    }

    public void hideSeries(String selectedSeriesId, boolean fireUpdate) {
        ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
        if (dataSeries != null) {
            this.selectedSeriesIds.remove(selectedSeriesId);
            dataSeries.setVisible(false);
            dataSeries.setVisibleInLegend(false);
            if (fireUpdate) {
                this.fireSeriesStatusEvent(selectedSeriesId, 2);
            }
        }
    }

    public void resetSeriesSettings() {
        this.resetSeriesSettings(true);
    }

    public void resetSeriesSettings(boolean fireUpdate) {
        ISeries[] series;
        ISeries[] iSeriesArray = series = this.getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries dataSeries = iSeriesArray[n2];
            ISeriesSettings seriesSettings = this.getSeriesSettings(dataSeries.getId());
            this.applySeriesSettings(dataSeries, seriesSettings);
            ++n2;
        }
        this.selectedSeriesIds.clear();
        this.redraw();
        if (fireUpdate) {
            this.fireSeriesStatusEvent(SELECTED_SERIES_NONE, 3);
        }
    }

    public void showSeries(String selectedSeriesId) {
        ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
        if (dataSeries != null) {
            dataSeries.setVisible(true);
            dataSeries.setVisibleInLegend(true);
        }
    }

    public void applySeriesSettings(ISeries<?> dataSeries, ISeriesSettings seriesSettings) {
        if (dataSeries instanceof ILineSeries) {
            ILineSeries lineSeries = (ILineSeries)dataSeries;
            if (seriesSettings instanceof ILineSeriesSettings) {
                ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
                this.applyLineSeriesSettings(lineSeries, lineSeriesSettings);
            } else if (seriesSettings instanceof IScatterSeriesSettings) {
                IScatterSeriesSettings scatterSeriesSettings = (IScatterSeriesSettings)seriesSettings;
                this.applyScatterSeriesSettings(lineSeries, scatterSeriesSettings);
            }
        } else if (dataSeries instanceof IBarSeries) {
            IBarSeries barSeries = (IBarSeries)dataSeries;
            if (seriesSettings instanceof IBarSeriesSettings) {
                IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
                this.applyBarSeriesSettings(barSeries, barSeriesSettings);
            }
        }
    }

    public void applyLineSeriesSettings(ILineSeries<?> lineSeries, ILineSeriesSettings lineSeriesSettings) {
        lineSeries.setDescription(lineSeriesSettings.getDescription());
        lineSeries.setVisible(lineSeriesSettings.isVisible());
        lineSeries.setVisibleInLegend(lineSeriesSettings.isVisibleInLegend());
        lineSeries.setAntialias(lineSeriesSettings.getAntialias());
        lineSeries.enableArea(lineSeriesSettings.isEnableArea());
        lineSeries.setSymbolType(lineSeriesSettings.getSymbolType());
        lineSeries.setSymbolSize(lineSeriesSettings.getSymbolSize());
        lineSeries.setSymbolColor(lineSeriesSettings.getSymbolColor());
        lineSeries.setLineColor(lineSeriesSettings.getLineColor());
        lineSeries.setLineWidth(lineSeriesSettings.getLineWidth());
        lineSeries.enableStack(lineSeriesSettings.isEnableStack());
        lineSeries.enableStep(lineSeriesSettings.isEnableStep());
        lineSeries.setLineStyle(lineSeriesSettings.getLineStyle());
    }

    public void applyScatterSeriesSettings(ILineSeries<?> scatterSeries, IScatterSeriesSettings scatterSeriesSettings) {
        scatterSeries.setDescription(scatterSeriesSettings.getDescription());
        scatterSeries.setVisible(scatterSeriesSettings.isVisible());
        scatterSeries.setVisibleInLegend(scatterSeriesSettings.isVisibleInLegend());
        scatterSeries.enableArea(false);
        scatterSeries.setSymbolType(scatterSeriesSettings.getSymbolType());
        scatterSeries.setSymbolSize(scatterSeriesSettings.getSymbolSize());
        scatterSeries.setSymbolColor(scatterSeriesSettings.getSymbolColor());
        scatterSeries.setLineStyle(LineStyle.NONE);
    }

    public void applyBarSeriesSettings(IBarSeries<?> barSeries, IBarSeriesSettings barSeriesSettings) {
        barSeries.setDescription(barSeriesSettings.getDescription());
        barSeries.setVisible(barSeriesSettings.isVisible());
        barSeries.setVisibleInLegend(barSeriesSettings.isVisibleInLegend());
        barSeries.setBarColor(barSeriesSettings.getBarColor());
        barSeries.setBarPadding(barSeriesSettings.getBarPadding());
        barSeries.setBarWidth(barSeriesSettings.getBarWidth());
        barSeries.setBarOverlay(barSeriesSettings.isBarOverlay());
        barSeries.enableStack(barSeriesSettings.isEnableStack());
    }

    public List<double[]> getDataShiftHistory(String selectedSeriesId) {
        List<double[]> dataShifts = this.dataShiftHistory.get(selectedSeriesId);
        if (dataShifts != null) {
            return Collections.unmodifiableList(dataShifts);
        }
        return null;
    }

    public boolean isDataShifted() {
        for (Collection collection : this.dataShiftHistory.values()) {
            if (collection == null) continue;
            return true;
        }
        return false;
    }

    public void setShiftConstraints(int shiftConstraints) {
        this.shiftConstraints = shiftConstraints;
    }

    public void shiftSeries(String selectedSeriesId, double shiftX, double shiftY) {
        ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
        if (dataSeries != null && (shiftX != 0.0 || shiftY != 0.0)) {
            double seriesMinX = Double.MAX_VALUE;
            double seriesMaxX = Double.MIN_VALUE;
            double seriesMinY = Double.MAX_VALUE;
            double seriesMaxY = Double.MIN_VALUE;
            if (shiftX != 0.0) {
                double[] xSeriesShifted = this.adjustArray(dataSeries.getXSeries(), shiftX, "X_AXIS");
                dataSeries.setXSeries(xSeriesShifted);
                seriesMinX = xSeriesShifted[0];
                seriesMaxX = xSeriesShifted[xSeriesShifted.length - 1];
            }
            if (shiftY != 0.0) {
                double[] ySeriesShifted = this.adjustArray(dataSeries.getYSeries(), shiftY, "Y_AXIS");
                dataSeries.setYSeries(ySeriesShifted);
                seriesMinY = ySeriesShifted[0];
                seriesMaxY = ySeriesShifted[ySeriesShifted.length - 1];
            }
            Range rangeX = this.getAxisSet().getXAxis(0).getRange();
            Range rangeY = this.getAxisSet().getYAxis(0).getRange();
            List<double[]> shiftRecord = this.getShiftRecord(selectedSeriesId);
            shiftRecord.add(new double[]{rangeX.lower, rangeX.upper, shiftX, rangeY.lower, rangeY.upper, shiftY, this.shiftConstraints});
            this.updateCoordinates(seriesMinX, seriesMaxX, seriesMinY, seriesMaxY);
            this.fireSeriesModificationEvent();
        }
    }

    private List<double[]> getShiftRecord(String selectedSeriesId) {
        List<double[]> shiftRecord = this.dataShiftHistory.get(selectedSeriesId);
        if (shiftRecord == null) {
            shiftRecord = new ArrayList<double[]>();
            this.dataShiftHistory.put(selectedSeriesId, shiftRecord);
        }
        return shiftRecord;
    }

    private double[] adjustArray(double[] series, double shift, String axisOrientation) {
        boolean deleteShiftedData;
        series = this.shiftConstraints == 0 ? this.adjustArrayWithoutConstraints(series, shift) : ((deleteShiftedData = this.isDeleteShiftedData(axisOrientation)) ? this.adjustArrayWithConstraints(series, shift, axisOrientation) : this.adjustArrayWithoutConstraints(series, shift));
        return series;
    }

    private double[] adjustArrayWithoutConstraints(double[] series, double shift) {
        int i = 0;
        while (i < series.length) {
            int n = i++;
            series[n] = series[n] + shift;
        }
        return series;
    }

    private double[] adjustArrayWithConstraints(double[] series, double shift, String axisOrientation) {
        double lowerBorder = 0.0;
        int i = 0;
        while (i < series.length) {
            double valueShifted = series[i] + shift;
            series[i] = valueShifted >= lowerBorder ? valueShifted : 0.0;
            ++i;
        }
        return series;
    }

    private boolean isDeleteShiftedData(String axisOrientation) {
        if (axisOrientation.equals("X_AXIS")) {
            return (this.shiftConstraints & 2) == 2 && this.chartSettings.getRangeRestriction().isZeroX();
        }
        return (this.shiftConstraints & 4) == 4 && this.chartSettings.getRangeRestriction().isZeroY();
    }

    public void multiplySeries(String selectedSeriesId, String axisId, double factor) {
        ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
        if (dataSeries != null) {
            double[] xSeries = dataSeries.getXSeries();
            double[] ySeries = dataSeries.getYSeries();
            if ("X_AXIS".equals(axisId)) {
                dataSeries.setXSeries(this.multiplySeries(xSeries, factor));
            } else if ("Y_AXIS".equals(axisId)) {
                dataSeries.setYSeries(this.multiplySeries(ySeries, factor));
            }
            double seriesMinX = Arrays.stream(xSeries).min().getAsDouble();
            double seriesMaxX = Arrays.stream(xSeries).max().getAsDouble();
            double seriesMinY = Arrays.stream(ySeries).min().getAsDouble();
            double seriesMaxY = Arrays.stream(ySeries).max().getAsDouble();
            this.updateCoordinates(seriesMinX, seriesMaxX, seriesMinY, seriesMaxY);
            this.fireSeriesModificationEvent();
        }
    }

    private double[] multiplySeries(double[] series, double factor) {
        int i = 0;
        while (i < series.length) {
            int n = i++;
            series[n] = series[n] * factor;
        }
        return series;
    }

    public String[] getAxisLabels(String axisOrientation) {
        List<IAxisSettings> axisSettingsList = this.getAxisSettings(axisOrientation);
        int size = axisSettingsList.size();
        String[] items = new String[size];
        int i = 0;
        while (i < size) {
            IAxisSettings axisSettings = axisSettingsList.get(i);
            String label = axisSettings != null ? axisSettings.getLabel() : Messages.getString(Messages.NOT_SET);
            items[i] = label;
            ++i;
        }
        return items;
    }

    public List<IAxisSettings> getAxisSettings(String axisOrientation) {
        ArrayList<IAxisSettings> axisSettingsList = new ArrayList<IAxisSettings>();
        IAxis[] axes = this.getAxes(axisOrientation);
        int i = 0;
        while (i < axes.length) {
            IAxisSettings axisSettings = this.getAxisSettings(axisOrientation, i);
            if (axisSettings != null) {
                axisSettingsList.add(axisSettings);
            }
            ++i;
        }
        return axisSettingsList;
    }

    public DecimalFormat getDecimalFormat(String axisOrientation, int id) {
        IAxisSettings axisSettings = this.getAxisSettings(axisOrientation, id);
        DecimalFormat decimalFormat = axisSettings != null ? axisSettings.getDecimalFormat() : new DecimalFormat();
        return decimalFormat;
    }

    public IAxisScaleConverter getAxisScaleConverter(String axisOrientation, int id) {
        IAxisScaleConverter axisScaleConverter = null;
        IAxisSettings axisSettings = null;
        axisSettings = axisOrientation.equals("X_AXIS") ? this.getXAxisSettings(id) : this.getYAxisSettings(id);
        if (axisSettings instanceof ISecondaryAxisSettings) {
            axisScaleConverter = ((ISecondaryAxisSettings)axisSettings).getAxisScaleConverter();
        }
        return axisScaleConverter;
    }

    protected void fireUpdateCustomRangeSelectionHandlers() {
        Event event = new Event();
        this.fireUpdateCustomRangeSelectionHandlers(event);
    }

    public void fireUpdateCustomRangeSelectionHandlers(Event event) {
        for (ICustomSelectionHandler customSelectionHandler : this.customRangeSelectionHandlers) {
            try {
                customSelectionHandler.handleUserSelection(event);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    protected void fireUpdateCustomPointSelectionHandlers() {
        Event event = new Event();
        this.fireUpdateCustomPointSelectionHandlers(event);
    }

    public void fireUpdateCustomPointSelectionHandlers(Event event) {
        for (ICustomSelectionHandler customSelectionHandler : this.customPointSelectionHandlers) {
            try {
                customSelectionHandler.handleUserSelection(event);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private void fireSeriesModificationEvent() {
        for (ISeriesModificationListener seriesModificationListener : this.seriesModificationListeners) {
            try {
                seriesModificationListener.handleSeriesModificationEvent();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private void fireSeriesStatusEvent(String seriesId, int status) {
        for (ISeriesStatusListener seriesStatusListener : this.seriesStatusListeners) {
            try {
                switch (status) {
                    case 1: {
                        seriesStatusListener.handleSeriesSelectionEvent(seriesId);
                        break;
                    }
                    case 2: {
                        seriesStatusListener.handleSeriesHideEvent(seriesId);
                        break;
                    }
                    case 3: {
                        seriesStatusListener.handleSeriesResetEvent(seriesId);
                        break;
                    }
                    case 4: {
                        seriesStatusListener.handleRedrawEvent();
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void zoomX(IAxis xAxis, Event event) {
        double coordinateX;
        this.trackUndoSelection();
        boolean isZoomReferenceX0 = this.getChartSettings().getRangeRestriction().isReferenceZoomZeroX();
        double d = coordinateX = isZoomReferenceX0 ? 0.0 : xAxis.getDataCoordinate(event.x);
        if (event.count > 0) {
            xAxis.zoomIn(coordinateX);
        } else if (isZoomReferenceX0) {
            xAxis.zoomOut();
        } else {
            xAxis.zoomOut(coordinateX);
        }
        this.trackRedoSelection();
    }

    public void zoomY(IAxis yAxis, Event event) {
        double coordinateY;
        this.trackUndoSelection();
        boolean isZoomReferenceY0 = this.getChartSettings().getRangeRestriction().isReferenceZoomZeroY();
        double d = coordinateY = isZoomReferenceY0 ? 0.0 : yAxis.getDataCoordinate(event.y);
        if (event.count > 0) {
            yAxis.zoomIn(coordinateY);
        } else if (isZoomReferenceY0) {
            yAxis.zoomOut();
        } else {
            yAxis.zoomOut(coordinateY);
        }
        this.trackRedoSelection();
    }

    public String getSelectedseriesId(Event event) {
        ISeries[] series = this.getSeriesSet().getSeries();
        String selectedSeriesId = "";
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        block0: while (n2 < n) {
            ISeries dataSeries = iSeriesArray[n2];
            if (dataSeries != null) {
                int size = dataSeries.getXSeries().length;
                int i = 0;
                while (i < size) {
                    Point point = dataSeries.getPixelCoordinates(i);
                    if (this.isDataSeriesSelected(point, event, 8)) {
                        selectedSeriesId = dataSeries.getId();
                        break block0;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return selectedSeriesId;
    }

    private boolean isDataSeriesSelected(Point point, Event event, int delta) {
        return point.x >= event.x - delta && point.x <= event.x + delta && point.y >= event.y - delta && point.y <= event.y + delta;
    }

    public void handleUserSelection(Event event) {
        int deltaHeight;
        int minSelectedHeight;
        int deltaWidth;
        int minSelectedWidth;
        Point point = this.getPlotArea().getSize();
        if (this.getOrientation() == 256) {
            minSelectedWidth = point.x / 30;
            deltaWidth = Math.abs(this.userSelection.getStartX() - event.x);
            minSelectedHeight = point.y / 30;
            deltaHeight = Math.abs(this.userSelection.getStartY() - event.y);
        } else {
            minSelectedWidth = point.y / 30;
            deltaWidth = Math.abs(this.userSelection.getStartY() - event.y);
            minSelectedHeight = point.x / 30;
            deltaHeight = Math.abs(this.userSelection.getStartX() - event.x);
        }
        RangeRestriction rangeRestriction = this.getRangeRestriction();
        if (rangeRestriction.isRestrictSelectY()) {
            if (deltaHeight >= minSelectedHeight) {
                this.handleUserSelectionXY(event);
            }
        } else if (deltaWidth >= minSelectedWidth) {
            this.handleUserSelectionXY(event);
        }
        this.userSelection.reset();
        this.redraw();
    }

    public void redraw() {
        super.redraw();
        this.fireSeriesStatusEvent("", 4);
    }

    public boolean isBufferActive() {
        return this.getPlotArea().isBuffered();
    }

    private void handleUserSelectionXY(Event event) {
        this.trackUndoSelection();
        int xStart = this.userSelection.getStartX();
        int xStop = this.userSelection.getStopX();
        int yStart = this.userSelection.getStartY();
        int yStop = this.userSelection.getStopY();
        this.setSelectionXY(xStart, xStop, yStart, yStop);
        this.trackRedoSelection();
        this.fireUpdateCustomRangeSelectionHandlers(event);
    }

    private void trackUndoSelection() {
        Range xRange = this.getAxisSet().getXAxis(0).getRange();
        Range yRange = this.getAxisSet().getYAxis(0).getRange();
        this.handledSelectionEvents.push(new double[]{xRange.lower, xRange.upper, yRange.lower, yRange.upper});
    }

    private void trackRedoSelection() {
        Range xRange = this.getAxisSet().getXAxis(0).getRange();
        Range yRange = this.getAxisSet().getYAxis(0).getRange();
        this.redoSelection = new double[]{xRange.lower, xRange.upper, yRange.lower, yRange.upper};
    }

    public void undoSelection() {
        try {
            double[] undoSelection = this.handledSelectionEvents.pop();
            this.handleSelection(undoSelection);
        }
        catch (EmptyStackException e) {
            System.out.println(e);
        }
    }

    public void redoSelection() {
        if (this.redoSelection != null) {
            this.handleSelection(this.redoSelection);
            this.redoSelection = null;
        }
    }

    private void handleSelection(double[] selection) {
        double xStart = selection[0];
        double xStop = selection[1];
        double yStart = selection[2];
        double yStop = selection[3];
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        this.setRange(xAxis, xStart, xStop, false);
        this.setRange(yAxis, yStart, yStop, false);
    }

    private void setSelectionXY(int xStart, int xStop, int yStart, int yStop) {
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        if (this.getOrientation() == 256) {
            this.setHorizontalRange(xAxis, yAxis, xStart, xStop, yStart, yStop);
        } else {
            this.setVerticalRange(xAxis, yAxis, xStart, xStop, yStart, yStop);
        }
    }

    private void setHorizontalRange(IAxis xAxis, IAxis yAxis, int xStart, int xStop, int yStart, int yStop) {
        RangeRestriction rangeRestriction = this.getRangeRestriction();
        if (this.isSelectXY(rangeRestriction)) {
            this.setRange(xAxis, xStart, xStop, true);
            this.setRange(yAxis, yStart, yStop, true);
        } else if (rangeRestriction.isRestrictSelectX()) {
            this.setRange(xAxis, xStart, xStop, true);
        } else if (rangeRestriction.isRestrictSelectY()) {
            this.setRange(yAxis, yStart, yStop, true);
        }
    }

    private void setVerticalRange(IAxis xAxis, IAxis yAxis, int xStart, int xStop, int yStart, int yStop) {
        RangeRestriction rangeRestriction = this.getRangeRestriction();
        if (this.isSelectXY(rangeRestriction)) {
            this.setRange(xAxis, yStart, yStop, true);
            this.setRange(yAxis, xStart, xStop, true);
        } else if (rangeRestriction.isRestrictSelectX()) {
            this.setRange(xAxis, yStart, yStop, true);
        } else if (rangeRestriction.isRestrictSelectY()) {
            this.setRange(yAxis, xStart, xStop, true);
        }
    }

    private IAxis[] getAxes(String axisOrientation) {
        IAxisSet axisSet = this.getAxisSet();
        if (axisOrientation.equals("X_AXIS")) {
            return axisSet.getXAxes();
        }
        return axisSet.getYAxes();
    }

    private IAxisSettings getAxisSettings(String axisOrientation, int id) {
        IAxisSettings axisSettings = null;
        axisSettings = axisOrientation.equals("X_AXIS") ? this.getXAxisSettings(id) : this.getYAxisSettings(id);
        return axisSettings;
    }

    @Deprecated
    public boolean isZoomXAndY(RangeRestriction rangeRestriction) {
        return this.isSelectXY(rangeRestriction);
    }

    public boolean isSelectXY(RangeRestriction rangeRestriction) {
        boolean enableAction = false;
        if (!rangeRestriction.isRestrictSelectX() && !rangeRestriction.isRestrictSelectY()) {
            enableAction = true;
        } else if (rangeRestriction.isRestrictSelectX() && rangeRestriction.isRestrictSelectY()) {
            enableAction = true;
        }
        return enableAction;
    }

    public boolean isZoomXY(RangeRestriction rangeRestriction) {
        boolean enableAction = false;
        if (!rangeRestriction.isRestrictZoomX() && !rangeRestriction.isRestrictZoomY()) {
            enableAction = true;
        } else if (rangeRestriction.isRestrictZoomX() && rangeRestriction.isRestrictZoomY()) {
            enableAction = true;
        }
        return enableAction;
    }
}

