/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.internal.support.SeriesLabelProvider;

public class SeriesComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int propertyIndex = 0;
    private int direction = 1;

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof ISeries && e2 instanceof ISeries) {
            ISeries series1 = (ISeries)e1;
            Color color1 = SeriesLabelProvider.getColor(series1);
            ISeries series2 = (ISeries)e2;
            Color color2 = SeriesLabelProvider.getColor(series2);
            switch (this.propertyIndex) {
                case 0: {
                    sortOrder = Boolean.compare(series1.isVisible(), series2.isVisible());
                    break;
                }
                case 1: {
                    sortOrder = Boolean.compare(series1.isVisibleInLegend(), series2.isVisibleInLegend());
                    break;
                }
                case 2: {
                    sortOrder = color1 != null && color2 != null ? color1.toString().compareTo(color2.toString()) : 0;
                    break;
                }
                case 3: {
                    sortOrder = series1.getDescription().compareTo(series2.getDescription());
                    break;
                }
                case 4: {
                    sortOrder = series1.getId().compareTo(series2.getId());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.direction == 1) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

