/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.internal.ChartLayoutData;
import org.eclipse.swtchart.internal.Title;
import org.eclipse.swtchart.internal.Util;
import org.eclipse.swtchart.internal.series.LineSeries;
import org.eclipse.swtchart.internal.series.Series;

public class Legend
extends Composite
implements ILegend,
PaintListener {
    private Chart chart;
    private boolean visible;
    private int position;
    private static final int MARGIN = 5;
    private static final int SYMBOL_WIDTH = 20;
    private static final int LINE_WIDTH = 2;
    private static final Color DEFAULT_FOREGROUND = Display.getDefault().getSystemColor(2);
    private static final Color DEFAULT_BACKGROUND = Display.getDefault().getSystemColor(1);
    private Font defaultFont;
    private static final int DEFAULT_FONT_SIZE = 9;
    private static final int DEFAULT_POSITION = 131072;
    private Map<String, Rectangle> cellBounds;

    public Legend(Chart chart, int style) {
        super((Composite)chart, style | 0x20000000);
        this.chart = chart;
        this.visible = true;
        this.position = 131072;
        this.cellBounds = new HashMap<String, Rectangle>();
        this.defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 9, 0);
        this.setFont(this.defaultFont);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setBackground(DEFAULT_BACKGROUND);
        this.addPaintListener(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.chart.updateLayout();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            super.setFont(this.defaultFont);
        } else {
            super.setFont(font);
        }
        this.chart.updateLayout();
    }

    @Override
    public void setForeground(Color color) {
        if (color == null) {
            super.setForeground(DEFAULT_FOREGROUND);
        } else {
            super.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            super.setBackground(DEFAULT_BACKGROUND);
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int value) {
        this.position = value == 16384 || value == 131072 || value == 128 || value == 1024 ? value : 131072;
        this.chart.updateLayout();
    }

    @Override
    public Rectangle getBounds(String seriesId) {
        if (seriesId == null) {
            SWT.error((int)5);
        }
        return this.cellBounds.get(seriesId.trim());
    }

    public void dispose() {
        super.dispose();
        if (!this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
    }

    private ISeries<?>[] sort(ISeries<?>[] seriesArray) {
        HashMap map = new HashMap();
        ISeries<?>[] iSeriesArray = seriesArray;
        int n = seriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries<?> series = iSeriesArray[n2];
            int axisId = series.getXAxisId();
            ArrayList list = (ArrayList)map.get(axisId);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(series);
            map.put(axisId, list);
            ++n2;
        }
        ArrayList sortedArray = new ArrayList();
        boolean isVertical = this.chart.getOrientation() == 512;
        for (Map.Entry entry : map.entrySet()) {
            boolean isCategoryEnabled = this.chart.getAxisSet().getXAxis((Integer)entry.getKey()).isCategoryEnabled();
            sortedArray.addAll(Legend.sort((List)entry.getValue(), isCategoryEnabled, isVertical));
        }
        return sortedArray.toArray(new ISeries[sortedArray.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private static List<ISeries<?>> sort(List<ISeries<?>> seriesList, boolean isCategoryEnabled, boolean isVertical) {
        sortedArray = new ArrayList<ISeries<?>>();
        insertIndex = -1;
        i = 0;
        while (i < seriesList.size()) {
            if (!isCategoryEnabled || !((Series)seriesList.get(i)).isValidStackSeries()) ** GOTO lbl10
            if (insertIndex != -1) {
                sortedArray.add(insertIndex, seriesList.get(i));
            } else {
                insertIndex = i;
lbl10:
                // 2 sources

                sortedArray.add(seriesList.get(i));
            }
            ++i;
        }
        if (isVertical) {
            Collections.reverse(sortedArray);
        }
        return sortedArray;
    }

    public void updateLayoutData() {
        if (!this.visible) {
            this.setLayoutData(new ChartLayoutData(0, 0));
            return;
        }
        int width = 0;
        int height = 0;
        ISeries<?>[] seriesArray = this.sort(this.chart.getSeriesSet().getSeries());
        Rectangle r = this.chart.getClientArea();
        Rectangle titleBounds = ((Title)this.chart.getTitle()).getBounds();
        int titleHeight = titleBounds.y + titleBounds.height;
        int cellHeight = Util.getExtentInGC((Font)this.getFont(), null).y;
        if (this.position == 131072 || this.position == 16384) {
            int columns = 1;
            int yPosition = 5;
            int maxCellWidth = 0;
            ISeries<?>[] iSeriesArray = seriesArray;
            int n = seriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries<?> series = iSeriesArray[n2];
                if (series.isVisibleInLegend()) {
                    if (series instanceof ICircularSeries && ((ICircularSeries)((Object)series)).getLabels() != null) {
                        String[] labels = ((ICircularSeries)((Object)series)).getLabels();
                        int i = 0;
                        while (i != labels.length) {
                            int textWidth = Util.getExtentInGC((Font)this.getFont(), (String)labels[i]).x;
                            int cellWidth = textWidth + 20 + 15;
                            maxCellWidth = Math.max(maxCellWidth, cellWidth);
                            if (yPosition + cellHeight < r.height - titleHeight - 5 || yPosition == 5) {
                                yPosition += cellHeight + 5;
                            } else {
                                ++columns;
                                yPosition = cellHeight + 10;
                            }
                            this.cellBounds.put(labels[i], new Rectangle(maxCellWidth * (columns - 1), yPosition - cellHeight - 5, cellWidth, cellHeight));
                            height = Math.max(yPosition, height);
                            ++i;
                        }
                        width = maxCellWidth * columns;
                    } else {
                        String label = Legend.getLegendLabel(series);
                        int textWidth = Util.getExtentInGC((Font)this.getFont(), (String)label).x;
                        int cellWidth = textWidth + 20 + 15;
                        maxCellWidth = Math.max(maxCellWidth, cellWidth);
                        if (yPosition + cellHeight < r.height - titleHeight - 5 || yPosition == 5) {
                            yPosition += cellHeight + 5;
                        } else {
                            ++columns;
                            yPosition = cellHeight + 10;
                        }
                        this.cellBounds.put(series.getId(), new Rectangle(maxCellWidth * (columns - 1), yPosition - cellHeight - 5, cellWidth, cellHeight));
                        height = Math.max(yPosition, height);
                    }
                }
                ++n2;
            }
            width = maxCellWidth * columns;
        } else if (this.position == 128 || this.position == 1024) {
            int rows = 1;
            int xPosition = 0;
            ISeries<?>[] iSeriesArray = seriesArray;
            int n = seriesArray.length;
            int n3 = 0;
            while (n3 < n) {
                ISeries<?> series = iSeriesArray[n3];
                if (series.isVisibleInLegend()) {
                    if (series instanceof ICircularSeries && ((ICircularSeries)((Object)series)).getLabels() != null) {
                        String[] labels = ((ICircularSeries)((Object)series)).getLabels();
                        int i = 0;
                        while (i != labels.length) {
                            int textWidth = Util.getExtentInGC((Font)this.getFont(), (String)labels[i]).x;
                            int cellWidth = textWidth + 20 + 15;
                            if (xPosition + cellWidth < r.width || xPosition == 0) {
                                xPosition += cellWidth;
                            } else {
                                ++rows;
                                xPosition = cellWidth;
                            }
                            this.cellBounds.put(labels[i], new Rectangle(xPosition - cellWidth, (cellHeight + 5) * (rows - 1) + 5, cellWidth, cellHeight));
                            width = Math.max(xPosition, width);
                            ++i;
                        }
                        height = (cellHeight + 5) * rows + 5;
                    } else {
                        String label = Legend.getLegendLabel(series);
                        int textWidth = Util.getExtentInGC((Font)this.getFont(), (String)label).x;
                        int cellWidth = textWidth + 20 + 15;
                        if (xPosition + cellWidth < r.width || xPosition == 0) {
                            xPosition += cellWidth;
                        } else {
                            ++rows;
                            xPosition = cellWidth;
                        }
                        this.cellBounds.put(series.getId(), new Rectangle(xPosition - cellWidth, (cellHeight + 5) * (rows - 1) + 5, cellWidth, cellHeight));
                        width = Math.max(xPosition, width);
                    }
                }
                ++n3;
            }
            height = (cellHeight + 5) * rows + 5;
        }
        this.setLayoutData(new ChartLayoutData(width, height));
    }

    private static String getLegendLabel(ISeries<?> series) {
        String description = series.getDescription();
        if (description == null) {
            return series.getId();
        }
        return description;
    }

    protected void drawSymbol(GC gc, Series<?> series, Rectangle r) {
        if (!this.visible) {
            return;
        }
        if (series instanceof ILineSeries) {
            gc.setForeground(((ILineSeries)((Object)series)).getLineColor());
            gc.setLineWidth(2);
            int lineStyle = Util.getIndexDefinedInSWT(((ILineSeries)((Object)series)).getLineStyle());
            int x = r.x;
            int y = r.y + r.height / 2;
            if (lineStyle != 0) {
                gc.setLineStyle(lineStyle);
                gc.drawLine(x, y, x + 20, y);
            }
            Color color = ((ILineSeries)((Object)series)).getSymbolColor();
            Color[] colors = ((ILineSeries)((Object)series)).getSymbolColors();
            if (colors != null && colors.length > 0) {
                color = colors[0];
            }
            ((LineSeries)series).drawSeriesSymbol(gc, x + 10, y, color);
        } else if (series instanceof IBarSeries) {
            gc.setBackground(((IBarSeries)((Object)series)).getBarColor());
            int size = 10;
            int x = r.x + size / 2;
            int y = (int)((double)r.y - (double)size / 2.0 + (double)r.height / 2.0);
            gc.fillRectangle(x, y, size, size);
        }
    }

    public void paintControl(PaintEvent e) {
        if (!this.visible) {
            return;
        }
        GC gc = e.gc;
        gc.setFont(this.getFont());
        ISeries<?>[] seriesArray = this.chart.getSeriesSet().getSeries();
        if (seriesArray.length == 0) {
            return;
        }
        gc.fillRectangle(0, 0, this.getSize().x - 1, this.getSize().y - 1);
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        gc.setForeground(Display.getDefault().getSystemColor(15));
        gc.drawRectangle(0, 0, this.getSize().x - 1, this.getSize().y - 1);
        int i = 0;
        while (i < seriesArray.length) {
            if (seriesArray[i].isVisibleInLegend()) {
                if (seriesArray[i] instanceof ICircularSeries) {
                    ICircularSeries pieSeries = (ICircularSeries)((Object)seriesArray[i]);
                    String[] labels = pieSeries.getLabels();
                    Color[] color = pieSeries.getColors();
                    int j = 0;
                    while (j != labels.length) {
                        Rectangle r = this.cellBounds.get(labels[j]);
                        if (r != null) {
                            String labelPie = labels[j];
                            Color colorPie = color[j];
                            if (labelPie != null && colorPie != null) {
                                this.drawPieSymbol(gc, labelPie, colorPie, new Rectangle(r.x + 5, r.y + 5, 20, r.height - 10));
                                gc.setBackground(this.getBackground());
                                gc.setForeground(this.getForeground());
                                gc.drawText(labelPie, r.x + 20 + 10, r.y, true);
                            }
                        }
                        ++j;
                    }
                } else {
                    String id = seriesArray[i].getId();
                    Rectangle r = this.cellBounds.get(id);
                    this.drawSymbol(gc, (Series)seriesArray[i], new Rectangle(r.x + 5, r.y + 5, 20, r.height - 10));
                    String label = Legend.getLegendLabel(seriesArray[i]);
                    gc.setBackground(this.getBackground());
                    gc.setForeground(this.getForeground());
                    gc.drawText(label, r.x + 20 + 10, r.y, true);
                }
            }
            ++i;
        }
    }

    private void drawPieSymbol(GC gc, String string, Color color, Rectangle r) {
        gc.setBackground(color);
        int size = 10;
        int x = r.x + size / 2;
        int y = (int)((double)r.y - (double)size / 2.0 + (double)r.height / 2.0);
        gc.fillArc(x, y, size, size, 0, 360);
    }
}

