/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.compress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.internal.compress.Compress;
import org.eclipse.swtchart.model.IdNodeDataModel;
import org.eclipse.swtchart.model.Node;

public class CompressCircularSeries
extends Compress {
    private IdNodeDataModel model;
    private int maxTreeDepth;

    public CompressCircularSeries(IdNodeDataModel model) {
        this.model = model;
    }

    public void setColors() {
        int rootNodeLevel = ((ICircularSeries)((Object)this.model.getSeries())).getRootNodeLevel();
        Display device = Display.getDefault();
        this.maxTreeDepth = this.model.getRootNode().getMaxSubTreeDepth() - 1 + rootNodeLevel;
        List<Node>[] nodes = this.model.getNodes();
        int i = 1 + rootNodeLevel;
        while (i <= this.maxTreeDepth) {
            int len = nodes[i].size();
            float anglePerNode = 360.0f / (float)len;
            float brightness = Math.max(0.0f, (float)(i - 1 - rootNodeLevel) / (float)this.maxTreeDepth);
            int j = 0;
            while (j != len) {
                RGB rgb = new RGB(anglePerNode * (float)j, 1.0f, 1.0f - brightness);
                Color color = new Color((Device)device, rgb);
                nodes[i].get(j).setColor(color);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void addNecessaryPlots(ArrayList<Double> xList, ArrayList<Double> yList, ArrayList<Integer> indexList) {
    }

    public void update() {
        this.setColors();
    }
}

