/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.Compress;
import org.eclipse.swtchart.internal.compress.CompressCircularSeries;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.IdNodeDataModel;
import org.eclipse.swtchart.model.Node;

public abstract class CircularSeries
extends Series
implements ICircularSeries {
    protected Chart chart;
    protected IdNodeDataModel model;
    protected Node rootNode;
    protected int maxTreeDepth;
    protected Color borderColor;
    protected int borderWidth;
    protected int borderStyle;

    public CircularSeries(Chart chart, String id) {
        super(chart, id);
        this.chart = chart;
        this.initialise();
        this.model = new IdNodeDataModel(id, this);
        this.rootNode = this.model.getRootNode();
        this.compressor = new CompressCircularSeries(this.model);
        this.borderColor = Display.getDefault().getSystemColor(2);
        this.borderWidth = 1;
        this.borderStyle = 1;
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        return null;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public int getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    @Override
    public Compress getCompressor() {
        return (Compress)this.compressor;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Node getNodeById(String id) {
        return this.model.getTree().get(id);
    }

    @Override
    public List<Node> getSeries() {
        return this.rootNode.getChildren();
    }

    @Override
    public void addNode(String id, double val) {
        this.rootNode.addChild(id, val);
    }

    @Override
    public String[] getLabels() {
        String[] labels = new String[this.model.getTree().size() - 1];
        List<Node>[] nodes = this.model.getNodes();
        int index = 0;
        int i = 1;
        while (i <= this.maxTreeDepth) {
            int len = nodes[i].size();
            int j = 0;
            while (j != len) {
                labels[index] = nodes[i].get(j).getId();
                ++index;
                ++j;
            }
            ++i;
        }
        return labels;
    }

    @Override
    public Color[] getColors() {
        Color[] colors = new Color[this.model.getTree().size() - 1];
        List<Node>[] nodes = this.model.getNodes();
        int ind = 0;
        int i = 1;
        while (i <= this.maxTreeDepth) {
            int len = nodes[i].size();
            int j = 0;
            while (j != len) {
                colors[ind] = nodes[i].get(j).getColor();
                ++ind;
                ++j;
            }
            ++i;
        }
        return colors;
    }

    @Override
    public void setColor(Color[] colors) {
        int length = this.getLabels().length;
        int cfr_ignored_0 = colors.length;
        int i = 0;
        while (i != length) {
            if (colors[i] != null) {
                this.model.getNodeById(this.getLabels()[i]).setColor(colors[i]);
            }
            ++i;
        }
    }

    @Override
    public void setColor(String label, Color color) {
        Node node = this.model.getNodeById(label);
        if (node == null) {
            return;
        }
        node.setColor(color);
    }

    @Override
    public void setSeries(String[] labels, double[] values) {
        int length = labels.length;
        int cfr_ignored_0 = values.length;
        int i = 0;
        while (i != length) {
            new Node(labels[i], values[i], this.rootNode);
            ++i;
        }
        this.update();
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        this.setBothAxisRange(width, height, xAxis, yAxis);
        gc.setForeground(this.borderColor);
        gc.setLineStyle(this.borderStyle);
        gc.setLineWidth(this.borderWidth);
        this.drawNode(this.rootNode, gc, xAxis, yAxis);
    }

    protected void setBothAxisRange(int width, int height, Axis xAxis, Axis yAxis) {
        this.maxTreeDepth = this.getMaxTreeDepth();
        xAxis.setRange(new Range(-this.maxTreeDepth, this.maxTreeDepth));
        yAxis.setRange(new Range(-this.maxTreeDepth, this.maxTreeDepth));
        if (width > height) {
            if (xAxis.isHorizontalAxis()) {
                double ratio = (double)(2 * this.maxTreeDepth * width) / (double)height;
                xAxis.setRange(new Range(-this.maxTreeDepth, ratio - (double)this.maxTreeDepth));
            } else {
                double ratio = (double)(2 * this.maxTreeDepth * width) / (double)height;
                yAxis.setRange(new Range(-this.maxTreeDepth, ratio - (double)this.maxTreeDepth));
            }
        } else if (xAxis.isHorizontalAxis()) {
            double ratio = (double)(2 * this.maxTreeDepth * height) / (double)width;
            yAxis.setRange(new Range((double)this.maxTreeDepth - ratio, this.maxTreeDepth));
        } else {
            double ratio = (double)(2 * this.maxTreeDepth * height) / (double)width;
            xAxis.setRange(new Range((double)this.maxTreeDepth - ratio, this.maxTreeDepth));
        }
    }

    protected abstract void drawNode(Node var1, GC var2, Axis var3, Axis var4);

    @Override
    protected void setCompressor() {
        ((CompressCircularSeries)this.compressor).update();
    }

    private void initialise() {
        IAxis[] axes;
        IAxis[] iAxisArray = axes = this.chart.getAxisSet().getAxes();
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.getTick().setVisible(false);
            axis.getGrid().setVisible(false);
            axis.getTitle().setVisible(false);
            ++n2;
        }
    }
}

