/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.ArrayList;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.series.CircularSeries;
import org.eclipse.swtchart.model.Node;

public class Doughnut
extends CircularSeries {
    protected Doughnut(Chart chart, String id) {
        super(chart, id);
        this.type = ISeries.SeriesType.DOUGHNUT;
    }

    @Override
    public int getRootNodeLevel() {
        return 1;
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        return null;
    }

    @Override
    protected void drawNode(Node node, GC gc, Axis xAxis, Axis yAxis) {
        if (!node.getChildren().isEmpty()) {
            for (Node nodes : node.getChildren()) {
                this.drawNode(nodes, gc, xAxis, yAxis);
            }
        }
        if (!node.isVisible()) {
            return;
        }
        int level = node.getLevel();
        int xStart = xAxis.getPixelCoordinate(-level);
        int yStart = yAxis.getPixelCoordinate(level);
        int xWidth = xAxis.getPixelCoordinate(level) - xStart;
        int yWidth = yAxis.getPixelCoordinate(-level) - yStart;
        int xZero = xAxis.getPixelCoordinate(0.0);
        int yZero = yAxis.getPixelCoordinate(0.0);
        int angleStart = node.getAngleBounds().x;
        int angleWidth = node.getAngleBounds().y;
        gc.setBackground(node.getColor());
        gc.fillArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
        gc.drawArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
        double xStartCoordinate = (double)level * Math.cos(Math.toRadians(angleStart));
        double yStartCoordinate = (double)level * Math.sin(Math.toRadians(angleStart));
        int xStartPixelCoordinate = xAxis.getPixelCoordinate(xStartCoordinate);
        int yStartPixelCoordinate = yAxis.getPixelCoordinate(yStartCoordinate);
        if (node != this.rootNode) {
            gc.drawLine(xZero, yZero, xStartPixelCoordinate, yStartPixelCoordinate);
        }
        double xEndCoordinate = (double)level * Math.cos(Math.toRadians(angleStart + angleWidth));
        double yEndCoordinate = (double)level * Math.sin(Math.toRadians(angleStart + angleWidth));
        int xEndPixelCoordinate = xAxis.getPixelCoordinate(xEndCoordinate);
        int yEndPixelCoordinate = yAxis.getPixelCoordinate(yEndCoordinate);
        if (node != this.rootNode) {
            gc.drawLine(xZero, yZero, xEndPixelCoordinate, yEndPixelCoordinate);
        }
    }

    @Override
    protected void setBothAxisRange(int width, int height, Axis xAxis, Axis yAxis) {
        this.maxTreeDepth = this.getMaxTreeDepth();
        xAxis.setRange(new Range(-this.maxTreeDepth, this.maxTreeDepth));
        yAxis.setRange(new Range(-this.maxTreeDepth, this.maxTreeDepth));
        if (width > height) {
            if (xAxis.isHorizontalAxis()) {
                double ratio = (double)(2 * this.maxTreeDepth * width) / (double)height;
                xAxis.setRange(new Range(-this.maxTreeDepth, ratio - (double)this.maxTreeDepth));
            } else {
                double ratio = (double)(2 * this.maxTreeDepth * width) / (double)height;
                yAxis.setRange(new Range(-this.maxTreeDepth, ratio - (double)this.maxTreeDepth));
            }
        } else if (xAxis.isHorizontalAxis()) {
            double ratio = (double)(2 * this.maxTreeDepth * height) / (double)width;
            yAxis.setRange(new Range((double)this.maxTreeDepth - ratio, this.maxTreeDepth));
        } else {
            double ratio = (double)(2 * this.maxTreeDepth * height) / (double)width;
            xAxis.setRange(new Range((double)this.maxTreeDepth - ratio, this.maxTreeDepth));
        }
    }

    @Override
    public void update() {
        this.model.getRootNode().updateValues();
        this.maxTreeDepth = this.getMaxTreeDepth();
        this.model.setNodes(new ArrayList[this.maxTreeDepth + 1]);
        ArrayList[] node = (ArrayList[])this.model.getNodes();
        int i = 1;
        while (i <= this.maxTreeDepth) {
            node[i] = new ArrayList();
            ++i;
        }
        this.model.setNodes(node);
        this.model.getRootNode().updateAngularBounds();
        this.model.getRootNode().setVisibility(true);
        this.setCompressor();
    }

    @Override
    public int getMaxTreeDepth() {
        return this.rootNode.getMaxSubTreeDepth();
    }
}

