/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.ArrayList;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.Compress;
import org.eclipse.swtchart.internal.series.CircularSeries;
import org.eclipse.swtchart.model.Node;

public class Pie
extends CircularSeries {
    protected Pie(Chart chart, String id) {
        super(chart, id);
        this.type = ISeries.SeriesType.PIE;
    }

    @Override
    public Compress getCompressor() {
        return (Compress)this.compressor;
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        return null;
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        this.setBothAxisRange(width, height, xAxis, yAxis);
        gc.setForeground(this.borderColor);
        gc.setLineStyle(this.borderStyle);
        gc.setLineWidth(this.borderWidth);
        this.drawNode(this.rootNode, gc, xAxis, yAxis);
    }

    @Override
    protected void drawNode(Node node, GC gc, Axis xAxis, Axis yAxis) {
        if (!node.getChildren().isEmpty()) {
            for (Node nodes : node.getChildren()) {
                this.drawNode(nodes, gc, xAxis, yAxis);
            }
        }
        if (!node.isVisible()) {
            return;
        }
        int level = node.getLevel();
        int xStart = xAxis.getPixelCoordinate(-level);
        int yStart = yAxis.getPixelCoordinate(level);
        int xWidth = xAxis.getPixelCoordinate(level) - xStart;
        int yWidth = yAxis.getPixelCoordinate(-level) - yStart;
        int xZero = xAxis.getPixelCoordinate(0.0);
        int yZero = yAxis.getPixelCoordinate(0.0);
        int angleStart = node.getAngleBounds().x;
        int angleWidth = node.getAngleBounds().y;
        gc.setBackground(node.getColor());
        gc.fillArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
        gc.drawArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
        double xStartCoordinate = (double)level * Math.cos(Math.toRadians(angleStart));
        double yStartCoordinate = (double)level * Math.sin(Math.toRadians(angleStart));
        int xStartPixelCoordinate = xAxis.getPixelCoordinate(xStartCoordinate);
        int yStartPixelCoordinate = yAxis.getPixelCoordinate(yStartCoordinate);
        gc.drawLine(xZero, yZero, xStartPixelCoordinate, yStartPixelCoordinate);
        double xEndCoordinate = (double)level * Math.cos(Math.toRadians(angleStart + angleWidth));
        double yEndCoordinate = (double)level * Math.sin(Math.toRadians(angleStart + angleWidth));
        int xEndPixelCoordinate = xAxis.getPixelCoordinate(xEndCoordinate);
        int yEndPixelCoordinate = yAxis.getPixelCoordinate(yEndCoordinate);
        gc.drawLine(xZero, yZero, xEndPixelCoordinate, yEndPixelCoordinate);
    }

    @Override
    public void update() {
        this.model.getRootNode().updateValues();
        this.maxTreeDepth = this.getMaxTreeDepth();
        this.model.setNodes(new ArrayList[this.maxTreeDepth + 1]);
        ArrayList[] node = (ArrayList[])this.model.getNodes();
        int i = 1;
        while (i <= this.maxTreeDepth) {
            node[i] = new ArrayList();
            ++i;
        }
        this.model.setNodes(node);
        this.model.getRootNode().updateAngularBounds();
        this.model.getRootNode().setVisibility(true);
        this.setCompressor();
    }

    @Override
    public int getRootNodeLevel() {
        return 0;
    }

    @Override
    public int getMaxTreeDepth() {
        return this.rootNode.getMaxSubTreeDepth() - 1;
    }
}

