/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.Node;

public class IdNodeDataModel {
    private String Id;
    private Node rootNode;
    private Series<?> series;
    private HashMap<String, Node> tree;
    private List<Node>[] nodesAtLevels;

    public IdNodeDataModel(String Id, Series<?> series) {
        this.Id = Id;
        this.series = series;
        this.rootNode = new Node(Id, -1.0, this);
        this.tree = new HashMap();
        this.initialiseRootNode();
    }

    private void initialiseRootNode() {
        this.rootNode.changeParent(this.rootNode);
        this.rootNode.setVisibility(true);
        this.rootNode.setAngleBounds(new Point(0, 360));
        this.rootNode.setDataModel(this);
        this.rootNode.setColor(Display.getDefault().getSystemColor(1));
        this.tree.put(this.Id, this.rootNode);
    }

    public Series<?> getSeries() {
        return this.series;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public HashMap<String, Node> getTree() {
        return this.tree;
    }

    public Node getNodeById(String id) {
        return this.tree.get(id);
    }

    public List<Node>[] getNodes() {
        return this.nodesAtLevels;
    }

    public void setNodes(ArrayList<Node>[] arrayList) {
        this.nodesAtLevels = arrayList;
    }
}

