/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.AdditionalMappingsDialog;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ModelOperation
extends TeamOperation {
    private boolean previewRequested;
    private ISynchronizationScopeManager manager;

    public static ModelProvider[] sortByExtension(ModelProvider[] providers) {
        ArrayList<ModelProvider> result = new ArrayList<ModelProvider>();
        int i = 0;
        while (i < providers.length) {
            ModelProvider providerToInsert = providers[i];
            int index = result.size();
            int j = 0;
            while (j < result.size()) {
                ModelProvider provider = (ModelProvider)result.get(j);
                if (ModelOperation.extendsProvider(providerToInsert, provider)) {
                    index = j;
                    break;
                }
                ++j;
            }
            result.add(index, providerToInsert);
            ++i;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private static boolean extendsProvider(ModelProvider providerToInsert, ModelProvider provider) {
        String[] extended = providerToInsert.getDescriptor().getExtendedModels();
        int i = 0;
        while (i < extended.length) {
            String id = extended[i];
            if (id.equals(provider.getDescriptor().getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ModelOperation(IWorkbenchPart part, ISynchronizationScopeManager manager) {
        super(part);
        this.manager = manager;
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(null, 100);
            this.beginOperation(Policy.subMonitorFor((IProgressMonitor)monitor, (int)5));
            this.execute(Policy.subMonitorFor((IProgressMonitor)monitor, (int)90));
        }
        finally {
            this.endOperation(Policy.subMonitorFor((IProgressMonitor)monitor, (int)5));
            monitor.done();
        }
    }

    protected void beginOperation(IProgressMonitor monitor) throws InvocationTargetException {
        this.initializeScope(monitor);
    }

    protected void endOperation(IProgressMonitor monitor) throws InvocationTargetException {
    }

    protected final void initializeScope(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            if (!this.manager.isInitialized()) {
                this.manager.initialize(monitor);
                this.promptIfInputChange(monitor);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void promptIfInputChange(IProgressMonitor monitor) {
        ISynchronizationScope inputScope = this.getScope().asInputScope();
        if (this.getScope().hasAdditionalMappings()) {
            boolean prompt = false;
            ModelProvider[] inputModelProviders = inputScope.getModelProviders();
            if (this.hasAdditionalMappingsFromIndependantModel(inputModelProviders, this.getScope().getModelProviders())) {
                prompt = true;
            } else if (this.getScope().hasAdditonalResources()) {
                prompt = true;
            } else if (inputModelProviders.length == 1) {
                String modelProviderId = inputModelProviders[0].getDescriptor().getId();
                ResourceMapping[] mappings = this.getScope().getMappings();
                int i = 0;
                while (i < mappings.length) {
                    ResourceMapping mapping = mappings[i];
                    if (inputScope.getTraversals(mapping) == null) {
                        String id = mapping.getModelProviderId();
                        if (id.equals(modelProviderId) && !modelProviderId.equals("org.eclipse.core.resources.modelProvider")) {
                            prompt = true;
                            break;
                        }
                        if (this.isIndependantModel(modelProviderId, id)) {
                            prompt = true;
                            break;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < inputModelProviders.length) {
                    ResourceMapping[] scopeMappings;
                    ModelProvider provider = inputModelProviders[i];
                    String id = provider.getDescriptor().getId();
                    ResourceMapping[] inputMappings = inputScope.getMappings(id);
                    if (inputMappings.length != (scopeMappings = this.getScope().getMappings(id)).length) {
                        int j = 0;
                        while (j < scopeMappings.length) {
                            ResourceTraversal[] inputModelTraversals;
                            ResourceTraversal[] scopeTraversals;
                            ResourceMapping mapping = scopeMappings[j];
                            ResourceTraversal[] inputTraversals = inputScope.getTraversals(mapping);
                            if (inputTraversals == null && this.overlaps(scopeTraversals = this.getScope().getTraversals(mapping), inputModelTraversals = this.getTraversals(inputScope, inputMappings))) {
                                prompt = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (prompt) {
                String previewMessage = this.getPreviewRequestMessage();
                this.previewRequested = this.promptForInputChange(previewMessage, monitor);
            }
        }
    }

    protected String getPreviewRequestMessage() {
        return null;
    }

    private boolean hasAdditionalMappingsFromIndependantModel(ModelProvider[] inputModelProviders, ModelProvider[] modelProviders) {
        ModelProvider[] additionalProviders = this.getAdditionalProviders(inputModelProviders, modelProviders);
        int i = 0;
        while (i < additionalProviders.length) {
            ModelProvider additionalProvider = additionalProviders[i];
            boolean independant = true;
            int j = 0;
            while (j < inputModelProviders.length) {
                ModelProvider inputProvider = inputModelProviders[j];
                if (!this.isIndependantModel(additionalProvider.getDescriptor().getId(), inputProvider.getDescriptor().getId())) {
                    independant = false;
                }
                ++j;
            }
            if (independant) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ModelProvider[] getAdditionalProviders(ModelProvider[] inputModelProviders, ModelProvider[] modelProviders) {
        HashSet<ModelProvider> input = new HashSet<ModelProvider>();
        ArrayList<ModelProvider> result = new ArrayList<ModelProvider>();
        input.addAll(Arrays.asList(inputModelProviders));
        int i = 0;
        while (i < modelProviders.length) {
            ModelProvider provider = modelProviders[i];
            if (!input.contains(provider)) {
                result.add(provider);
            }
            ++i;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private boolean overlaps(ResourceTraversal[] scopeTraversals, ResourceTraversal[] inputModelTraversals) {
        int i = 0;
        while (i < inputModelTraversals.length) {
            ResourceTraversal inputTraversal = inputModelTraversals[i];
            int j = 0;
            while (j < scopeTraversals.length) {
                ResourceTraversal scopeTraversal = scopeTraversals[j];
                if (this.overlaps(inputTraversal, scopeTraversal)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean overlaps(ResourceTraversal inputTraversal, ResourceTraversal scopeTraversal) {
        IResource[] inputRoots = inputTraversal.getResources();
        IResource[] scopeRoots = scopeTraversal.getResources();
        int i = 0;
        while (i < scopeRoots.length) {
            IResource scopeResource = scopeRoots[i];
            int j = 0;
            while (j < inputRoots.length) {
                IResource inputResource = inputRoots[j];
                if (this.overlaps(scopeResource, scopeTraversal.getDepth(), inputResource, inputTraversal.getDepth())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean overlaps(IResource scopeResource, int scopeDepth, IResource inputResource, int inputDepth) {
        if (scopeResource.equals((Object)inputResource)) {
            return true;
        }
        if (scopeDepth == 2 && scopeResource.getFullPath().isPrefixOf(inputResource.getFullPath())) {
            return true;
        }
        if (scopeDepth == 1 && scopeResource.equals((Object)inputResource.getParent())) {
            return true;
        }
        if (inputDepth == 2 && inputResource.getFullPath().isPrefixOf(scopeResource.getFullPath())) {
            return true;
        }
        return inputDepth == 1 && inputResource.equals((Object)scopeResource.getParent());
    }

    private ResourceTraversal[] getTraversals(ISynchronizationScope inputScope, ResourceMapping[] inputMappings) {
        CompoundResourceTraversal result = new CompoundResourceTraversal();
        int i = 0;
        while (i < inputMappings.length) {
            ResourceMapping mapping = inputMappings[i];
            result.addTraversals(inputScope.getTraversals(mapping));
            ++i;
        }
        return result.asTraversals();
    }

    private boolean isIndependantModel(String modelProviderId, String id) {
        IModelProviderDescriptor desc2;
        if (id.equals(modelProviderId)) {
            return false;
        }
        IModelProviderDescriptor desc1 = ModelProvider.getModelProviderDescriptor((String)modelProviderId);
        return !this.isExtension(desc1, desc2 = ModelProvider.getModelProviderDescriptor((String)id)) && !this.isExtension(desc2, desc1);
    }

    private boolean isExtension(IModelProviderDescriptor desc1, IModelProviderDescriptor desc2) {
        String id;
        String[] ids = desc1.getExtendedModels();
        int i = 0;
        while (i < ids.length) {
            id = ids[i];
            if (id.equals(desc2.getId())) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            id = ids[i];
            IModelProviderDescriptor desc3 = ModelProvider.getModelProviderDescriptor((String)id);
            if (this.isExtension(desc3, desc2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean promptForInputChange(String requestPreviewMessage, IProgressMonitor monitor) {
        return this.showAllMappings(requestPreviewMessage);
    }

    private boolean showAllMappings(String requestPreviewMessage) {
        boolean[] canceled = new boolean[1];
        boolean[] forcePreview = new boolean[1];
        Display.getDefault().syncExec(() -> {
            AdditionalMappingsDialog dialog = new AdditionalMappingsDialog(this.getShell(), TeamUIMessages.ResourceMappingOperation_0, this.getScope(), this.getContext());
            dialog.setPreviewMessage(requestPreviewMessage);
            int result = dialog.open();
            boolean bl = blArray[0] = result != 0;
            if (requestPreviewMessage != null) {
                blArray2[0] = dialog.isForcePreview();
            }
        });
        if (canceled[0]) {
            throw new OperationCanceledException();
        }
        return forcePreview[0];
    }

    protected ISynchronizationContext getContext() {
        return null;
    }

    protected abstract void execute(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public ISynchronizationScope getScope() {
        return this.manager.getScope();
    }

    public boolean isPreviewRequested() {
        return this.previewRequested;
    }

    protected ISynchronizationScopeManager getScopeManager() {
        return this.manager;
    }
}

