/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.launch.CodewindLaunchConfigDelegate;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;

public class KubeUtil {
    private static final String KUBECTL_CMD = "kubectl";
    private static final String KUBECTL_EXE = "kubectl.exe";
    private static final String OC_CMD = "oc";
    private static final String OC_EXE = "oc.exe";
    private static String kubeCommand = null;

    public static String getCommand() {
        if (kubeCommand != null) {
            return kubeCommand;
        }
        boolean isWindows = CoreUtil.isWindows();
        String exec = CoreUtil.getExecutablePath(isWindows ? KUBECTL_EXE : KUBECTL_CMD);
        if (exec == null) {
            exec = CoreUtil.getExecutablePath(isWindows ? OC_EXE : OC_CMD);
        }
        kubeCommand = exec;
        return kubeCommand;
    }

    public static PortForwardInfo startPortForward(CodewindApplication app, int port) throws Exception {
        if (app.getPodName() == null || app.getNamespace() == null) {
            Logger.logError("Trying to port forward for the " + app.name + " project but the pod name or the namespace is null");
            return null;
        }
        String processPath = KubeUtil.getCommand();
        if (processPath == null) {
            Logger.logError("Port forwarding cannot be initiated because neither of the kubectl or oc commands could be found on the path");
            throw new IOException(Messages.ErrorNoKubectlMsg);
        }
        int localPort = PlatformUtil.findFreePort();
        if (localPort == -1) {
            Logger.logError("Could not find a free port to use for port forwarding for project: " + app.name);
            return null;
        }
        String portMapping = localPort + ":" + port;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(processPath);
        commandList.add("port-forward");
        commandList.add("-n");
        commandList.add(app.getNamespace());
        commandList.add(app.getPodName());
        commandList.add(portMapping);
        String title = NLS.bind((String)Messages.PortForwardTitle, (Object)portMapping);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.codewind.core.internal.utilityLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance((IContainer)null, app.name);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.connectionIdAttr", app.connection.getConid());
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.projectIdAttr", app.projectID);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.titleAttr", title);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.commandAttr", commandList);
        CodewindLaunchConfigDelegate.setConfigAttributes(workingCopy, app);
        ILaunchConfiguration launchConfig = workingCopy.doSave();
        ILaunch launch = launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
        return new PortForwardInfo(localPort, port, launch);
    }

    public static void endPortForward(CodewindApplication app, PortForwardInfo pfInfo) throws Exception {
        if (pfInfo != null && pfInfo.launch != null && !pfInfo.launch.isTerminated()) {
            pfInfo.launch.terminate();
        }
    }

    public static class PortForwardInfo {
        public final int localPort;
        public final int remotePort;
        public final ILaunch launch;

        public PortForwardInfo(int localPort, int remotePort, ILaunch launch) {
            this.localPort = localPort;
            this.remotePort = remotePort;
            this.launch = launch;
        }
    }
}

