/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.editors.WelcomePageEditorInput;
import org.eclipse.codewind.ui.internal.editors.WelcomePageEditorPart;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenWelcomePageAction
extends SelectionProviderAction {
    public OpenWelcomePageAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.WelcomePageAction);
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindManager) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        OpenWelcomePageAction.openWelcomePage();
    }

    public static IEditorPart openWelcomePage() {
        IWorkbenchWindow workbenchWindow = CodewindUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart editorPart = null;
        try {
            WelcomePageEditorInput input = new WelcomePageEditorInput();
            editorPart = page.openEditor((IEditorInput)input, "org.eclipse.codewind.ui.editors.welcomePage");
            if (!(editorPart instanceof WelcomePageEditorPart)) {
                Logger.logError((String)("Welcome page editor part is the wrong type: " + editorPart.getClass()));
                editorPart = null;
            }
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred opening the welcome page editor", (Throwable)e);
        }
        return editorPart;
    }
}

