/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementComposite;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceDetailsPage;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceURLPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddTemplateSourceWizard
extends Wizard
implements INewWizard {
    protected TemplateSourceURLPage urlPage;
    protected TemplateSourceDetailsPage detailsPage;

    public AddTemplateSourceWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.AddRepoDialogShell);
        this.urlPage = new TemplateSourceURLPage(Messages.AddRepoDialogShell, Messages.AddRepoDialogTitle);
        this.addPage((IWizardPage)this.urlPage);
        this.detailsPage = new TemplateSourceDetailsPage(Messages.AddRepoDialogShell, Messages.AddRepoDialogTitle);
        this.addPage((IWizardPage)this.detailsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.urlPage) {
            try {
                new URI(this.urlPage.getTemplateSourceUrl());
            }
            catch (URISyntaxException e) {
                IDEUtil.openInfoDialog(Messages.AddRepoDialogInvalidUrlTitle, NLS.bind((String)Messages.AddRepoDialogInvalidUrlError, (Object)e.toString()));
                this.urlPage.setErrorMessage(Messages.AddRepoDialogInvalidUrlMsg);
                return this.urlPage;
            }
            this.detailsPage.updatePage(this.urlPage.getTemplateSourceUrl(), this.urlPage.getAuthInfo());
            return this.detailsPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.urlPage.canFinish() && this.detailsPage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return this.canFinish();
    }

    RepositoryManagementComposite.RepoEntry getRepoEntry() {
        String url = this.urlPage.getTemplateSourceUrl();
        String name = this.detailsPage.getTemplateSourceName();
        String description = this.detailsPage.getTemplateSourceDescription();
        if (!(name == null || name.isEmpty() || description == null || description.isEmpty() || url == null || url.isEmpty())) {
            return new RepositoryManagementComposite.RepoEntry(url, this.urlPage.getAuthRequired(), this.urlPage.getUsername(), this.urlPage.getPassword(), this.urlPage.getToken(), name, description);
        }
        return null;
    }
}

